% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/Links.R
\name{links_ExpandGoogl}
\alias{links_ExpandGoogl}
\title{Expand a short URL to a longer one}
\usage{
links_ExpandGoogl(shortUrl = "", projection = NULL,
  showRequestURL = FALSE)
}
\arguments{
\item{shortUrl}{- The short URL, including the protocol.}

\item{projection}{- "FULL" - returns the creation timestamp and all available analytics (default) OR
"ANALYTICS_CLICKS" - returns only click counts OR "ANALYTICS_TOP_STRINGS" - returns only top
string counts (e.g. referrers, countries, etc)}

\item{showRequestURL}{- show URL which has been build and requested from server. For debug purposes.}
}
\value{
id - is the short URL you passed in.

longUrl - is the long URL to which it expands. Note that longUrl may not be present in
the response, for example, if status is "REMOVED".

status - is "OK" for most URLs. If Google believes that the URL is fishy, status may be
something else, such as "MALWARE".
}
\description{
For the given short URL, the url.get method returns the corresponding long URL and the status.
}
\note{
Returns a dataframe of expanded short URL and a list of its analytics.
}
\section{Quotas}{
 By default, your registered project gets 1,000,000 requests per day for the URL
Shortener API (\url{https://console.developers.google.com/})
}
\examples{
options(Goo.gl = "AIzaSyAbJt9APfph1JGIhflkoH9UuGhOACntOjw")
g1 <- links_ExpandGoogl(shortUrl = "http://goo.gl/vM0w4",showRequestURL = TRUE)
g4 <- links_ExpandGoogl(shortUrl="http://goo.gl/vM0w4",projection = "FULL",showRequestURL = TRUE)
}
\seealso{
See \url{https://developers.google.com/url-shortener/v1/getting_started#shorten}

See \url{https://developers.google.com/url-shortener/v1/url/get}
}

