% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mixnorm.R
\name{mixnorm}
\alias{mixnorm}
\alias{sigma}
\alias{mn2norm}
\alias{print.normMix}
\alias{summary.normMix}
\alias{sigma.normMix}
\alias{sigma<-}
\title{Normal Mixture Density}
\usage{
mixnorm(..., sigma, param = c("ms", "mn"))

mn2norm(m, n, sigma, drop = TRUE)

\method{print}{normMix}(x, ...)

\method{summary}{normMix}(object, probs = c(0.025, 0.5, 0.975), ...)

\method{sigma}{normMix}(object, ...)

sigma(object) <- value
}
\arguments{
\item{...}{List of mixture components.}

\item{sigma}{Reference scale.}

\item{param}{Determines how the parameters in the list are
interpreted. See details.}

\item{m}{Vector of means}

\item{n}{Vector of sample sizes.}

\item{drop}{Delete the dimensions of an array which have only one level.}

\item{x}{The mixture to print}

\item{object}{Normal mixture object.}

\item{probs}{Quantiles reported by the \code{summary} function.}

\item{value}{New value of the reference scale \code{sigma}.}
}
\value{
Returns a normal mixture with the specified mixture
components. \code{mn2norm} returns the mean and standard deviation
given a mean and sample size parametrization.
}
\description{
The normal mixture density and auxiliary functions.
}
\details{
Each entry in the \code{...} argument list is expected to
be a triplet of numbers which defines the weight \eqn{w_k}, first
and second parameter of the mixture component \eqn{k}. A triplet
can optionally be named which will be used appropriately.

The first and second parameter can be given in different
parametrizations which is set by the \code{param} option:
\describe{
\item{ms}{Mean and standard deviation. Default.}
\item{mn}{Mean and number of observations. \code{n} determines \code{s} via the relation \eqn{s=\sigma/\sqrt{n}} with \eqn{\sigma} being the fixed reference scale.}
}

The reference scale \eqn{\sigma} is the fixed standard deviation in
the one-parameter normal-normal model (observation standard
deviation). The function \code{sigma} can be used to query the
reference scale and may also be used to assign a new reference
scale, see examples below. In case the \code{sigma} is not
specified, the user has to supply \code{sigma} as argument to
functions which require a reference scale.
}
\section{Functions}{
\itemize{
\item \code{sigma(object) <- value}: Allows to assign a new reference scale \code{sigma}.

}}
\examples{

nm <- mixnorm(rob = c(0.2, 0, 2), inf = c(0.8, 2, 2), sigma = 5)

print(nm)
summary(nm)
plot(nm)

set.seed(57845)
mixSamp <- rmix(nm, 500)
plot(nm, samp = mixSamp)

# support defined by quantiles
qmix(nm, c(0.01, 0.99))

# density function
dmix(nm, seq(-5, 5, by = 2))

# distribution function
pmix(nm, seq(-5, 5, by = 2))

# the reference scale can be changed (it determines the ESS)
ess(nm)

sigma(nm) <- 10
ess(nm)
}
\seealso{
Other mixdist: 
\code{\link{mix}},
\code{\link{mixbeta}()},
\code{\link{mixcombine}()},
\code{\link{mixgamma}()},
\code{\link{mixmvnorm}()},
\code{\link{mixplot}}
}
\concept{mixdist}
