/*
THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.16.0

#include <stan/model/model_header.hpp>

namespace model_gMAP_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

typedef Eigen::Matrix<double,Eigen::Dynamic,1> vector_d;
typedef Eigen::Matrix<double,1,Eigen::Dynamic> row_vector_d;
typedef Eigen::Matrix<double,Eigen::Dynamic,Eigen::Dynamic> matrix_d;

static int current_statement_begin__;

stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_gMAP");
    reader.add_event(201, 201, "end", "model_gMAP");
    return reader;
}

class model_gMAP : public prob_grad {
private:
    int H;
    int link;
    vector_d y;
    vector_d y_se;
    vector<int> r;
    vector<int> r_n;
    vector<int> count;
    vector_d offset;
    int n_groups;
    vector<int> group_index;
    int n_tau_strata;
    int tau_strata_pred;
    vector<int> tau_strata_index;
    int mX;
    matrix_d X;
    matrix_d beta_prior;
    matrix_d tau_prior;
    int tau_prior_dist;
    int re_dist;
    double re_dist_t_df;
    int ncp;
    vector<vector_d> beta_raw_guess;
    vector<double> tau_raw_guess;
    vector<vector_d> beta_prior_stan;
    vector<vector_d> tau_prior_stan;
    matrix_d S;
    matrix_d Z;
    matrix_d X_param;
public:
    model_gMAP(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, 0, pstream__);
    }

    model_gMAP(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, random_seed__, pstream__);
    }

    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning

        current_statement_begin__ = -1;

        static const char* function__ = "model_gMAP_namespace::model_gMAP";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        // initialize member variables
        context__.validate_dims("data initialization", "H", "int", context__.to_vec());
        H = int(0);
        vals_i__ = context__.vals_i("H");
        pos__ = 0;
        H = vals_i__[pos__++];
        context__.validate_dims("data initialization", "link", "int", context__.to_vec());
        link = int(0);
        vals_i__ = context__.vals_i("link");
        pos__ = 0;
        link = vals_i__[pos__++];
        validate_non_negative_index("y", "H", H);
        context__.validate_dims("data initialization", "y", "vector_d", context__.to_vec(H));
        validate_non_negative_index("y", "H", H);
        y = vector_d(static_cast<Eigen::VectorXd::Index>(H));
        vals_r__ = context__.vals_r("y");
        pos__ = 0;
        size_t y_i_vec_lim__ = H;
        for (size_t i_vec__ = 0; i_vec__ < y_i_vec_lim__; ++i_vec__) {
            y[i_vec__] = vals_r__[pos__++];
        }
        validate_non_negative_index("y_se", "H", H);
        context__.validate_dims("data initialization", "y_se", "vector_d", context__.to_vec(H));
        validate_non_negative_index("y_se", "H", H);
        y_se = vector_d(static_cast<Eigen::VectorXd::Index>(H));
        vals_r__ = context__.vals_r("y_se");
        pos__ = 0;
        size_t y_se_i_vec_lim__ = H;
        for (size_t i_vec__ = 0; i_vec__ < y_se_i_vec_lim__; ++i_vec__) {
            y_se[i_vec__] = vals_r__[pos__++];
        }
        validate_non_negative_index("r", "H", H);
        context__.validate_dims("data initialization", "r", "int", context__.to_vec(H));
        validate_non_negative_index("r", "H", H);
        r = std::vector<int>(H,int(0));
        vals_i__ = context__.vals_i("r");
        pos__ = 0;
        size_t r_limit_0__ = H;
        for (size_t i_0__ = 0; i_0__ < r_limit_0__; ++i_0__) {
            r[i_0__] = vals_i__[pos__++];
        }
        validate_non_negative_index("r_n", "H", H);
        context__.validate_dims("data initialization", "r_n", "int", context__.to_vec(H));
        validate_non_negative_index("r_n", "H", H);
        r_n = std::vector<int>(H,int(0));
        vals_i__ = context__.vals_i("r_n");
        pos__ = 0;
        size_t r_n_limit_0__ = H;
        for (size_t i_0__ = 0; i_0__ < r_n_limit_0__; ++i_0__) {
            r_n[i_0__] = vals_i__[pos__++];
        }
        validate_non_negative_index("count", "H", H);
        context__.validate_dims("data initialization", "count", "int", context__.to_vec(H));
        validate_non_negative_index("count", "H", H);
        count = std::vector<int>(H,int(0));
        vals_i__ = context__.vals_i("count");
        pos__ = 0;
        size_t count_limit_0__ = H;
        for (size_t i_0__ = 0; i_0__ < count_limit_0__; ++i_0__) {
            count[i_0__] = vals_i__[pos__++];
        }
        validate_non_negative_index("offset", "H", H);
        context__.validate_dims("data initialization", "offset", "vector_d", context__.to_vec(H));
        validate_non_negative_index("offset", "H", H);
        offset = vector_d(static_cast<Eigen::VectorXd::Index>(H));
        vals_r__ = context__.vals_r("offset");
        pos__ = 0;
        size_t offset_i_vec_lim__ = H;
        for (size_t i_vec__ = 0; i_vec__ < offset_i_vec_lim__; ++i_vec__) {
            offset[i_vec__] = vals_r__[pos__++];
        }
        context__.validate_dims("data initialization", "n_groups", "int", context__.to_vec());
        n_groups = int(0);
        vals_i__ = context__.vals_i("n_groups");
        pos__ = 0;
        n_groups = vals_i__[pos__++];
        validate_non_negative_index("group_index", "H", H);
        context__.validate_dims("data initialization", "group_index", "int", context__.to_vec(H));
        validate_non_negative_index("group_index", "H", H);
        group_index = std::vector<int>(H,int(0));
        vals_i__ = context__.vals_i("group_index");
        pos__ = 0;
        size_t group_index_limit_0__ = H;
        for (size_t i_0__ = 0; i_0__ < group_index_limit_0__; ++i_0__) {
            group_index[i_0__] = vals_i__[pos__++];
        }
        context__.validate_dims("data initialization", "n_tau_strata", "int", context__.to_vec());
        n_tau_strata = int(0);
        vals_i__ = context__.vals_i("n_tau_strata");
        pos__ = 0;
        n_tau_strata = vals_i__[pos__++];
        context__.validate_dims("data initialization", "tau_strata_pred", "int", context__.to_vec());
        tau_strata_pred = int(0);
        vals_i__ = context__.vals_i("tau_strata_pred");
        pos__ = 0;
        tau_strata_pred = vals_i__[pos__++];
        validate_non_negative_index("tau_strata_index", "n_groups", n_groups);
        context__.validate_dims("data initialization", "tau_strata_index", "int", context__.to_vec(n_groups));
        validate_non_negative_index("tau_strata_index", "n_groups", n_groups);
        tau_strata_index = std::vector<int>(n_groups,int(0));
        vals_i__ = context__.vals_i("tau_strata_index");
        pos__ = 0;
        size_t tau_strata_index_limit_0__ = n_groups;
        for (size_t i_0__ = 0; i_0__ < tau_strata_index_limit_0__; ++i_0__) {
            tau_strata_index[i_0__] = vals_i__[pos__++];
        }
        context__.validate_dims("data initialization", "mX", "int", context__.to_vec());
        mX = int(0);
        vals_i__ = context__.vals_i("mX");
        pos__ = 0;
        mX = vals_i__[pos__++];
        validate_non_negative_index("X", "H", H);
        validate_non_negative_index("X", "mX", mX);
        context__.validate_dims("data initialization", "X", "matrix_d", context__.to_vec(H,mX));
        validate_non_negative_index("X", "H", H);
        validate_non_negative_index("X", "mX", mX);
        X = matrix_d(static_cast<Eigen::VectorXd::Index>(H),static_cast<Eigen::VectorXd::Index>(mX));
        vals_r__ = context__.vals_r("X");
        pos__ = 0;
        size_t X_m_mat_lim__ = H;
        size_t X_n_mat_lim__ = mX;
        for (size_t n_mat__ = 0; n_mat__ < X_n_mat_lim__; ++n_mat__) {
            for (size_t m_mat__ = 0; m_mat__ < X_m_mat_lim__; ++m_mat__) {
                X(m_mat__,n_mat__) = vals_r__[pos__++];
            }
        }
        validate_non_negative_index("beta_prior", "mX", mX);
        validate_non_negative_index("beta_prior", "2", 2);
        context__.validate_dims("data initialization", "beta_prior", "matrix_d", context__.to_vec(mX,2));
        validate_non_negative_index("beta_prior", "mX", mX);
        validate_non_negative_index("beta_prior", "2", 2);
        beta_prior = matrix_d(static_cast<Eigen::VectorXd::Index>(mX),static_cast<Eigen::VectorXd::Index>(2));
        vals_r__ = context__.vals_r("beta_prior");
        pos__ = 0;
        size_t beta_prior_m_mat_lim__ = mX;
        size_t beta_prior_n_mat_lim__ = 2;
        for (size_t n_mat__ = 0; n_mat__ < beta_prior_n_mat_lim__; ++n_mat__) {
            for (size_t m_mat__ = 0; m_mat__ < beta_prior_m_mat_lim__; ++m_mat__) {
                beta_prior(m_mat__,n_mat__) = vals_r__[pos__++];
            }
        }
        validate_non_negative_index("tau_prior", "n_tau_strata", n_tau_strata);
        validate_non_negative_index("tau_prior", "2", 2);
        context__.validate_dims("data initialization", "tau_prior", "matrix_d", context__.to_vec(n_tau_strata,2));
        validate_non_negative_index("tau_prior", "n_tau_strata", n_tau_strata);
        validate_non_negative_index("tau_prior", "2", 2);
        tau_prior = matrix_d(static_cast<Eigen::VectorXd::Index>(n_tau_strata),static_cast<Eigen::VectorXd::Index>(2));
        vals_r__ = context__.vals_r("tau_prior");
        pos__ = 0;
        size_t tau_prior_m_mat_lim__ = n_tau_strata;
        size_t tau_prior_n_mat_lim__ = 2;
        for (size_t n_mat__ = 0; n_mat__ < tau_prior_n_mat_lim__; ++n_mat__) {
            for (size_t m_mat__ = 0; m_mat__ < tau_prior_m_mat_lim__; ++m_mat__) {
                tau_prior(m_mat__,n_mat__) = vals_r__[pos__++];
            }
        }
        context__.validate_dims("data initialization", "tau_prior_dist", "int", context__.to_vec());
        tau_prior_dist = int(0);
        vals_i__ = context__.vals_i("tau_prior_dist");
        pos__ = 0;
        tau_prior_dist = vals_i__[pos__++];
        context__.validate_dims("data initialization", "re_dist", "int", context__.to_vec());
        re_dist = int(0);
        vals_i__ = context__.vals_i("re_dist");
        pos__ = 0;
        re_dist = vals_i__[pos__++];
        context__.validate_dims("data initialization", "re_dist_t_df", "double", context__.to_vec());
        re_dist_t_df = double(0);
        vals_r__ = context__.vals_r("re_dist_t_df");
        pos__ = 0;
        re_dist_t_df = vals_r__[pos__++];
        context__.validate_dims("data initialization", "ncp", "int", context__.to_vec());
        ncp = int(0);
        vals_i__ = context__.vals_i("ncp");
        pos__ = 0;
        ncp = vals_i__[pos__++];
        validate_non_negative_index("beta_raw_guess", "2", 2);
        validate_non_negative_index("beta_raw_guess", "mX", mX);
        context__.validate_dims("data initialization", "beta_raw_guess", "vector_d", context__.to_vec(2,mX));
        validate_non_negative_index("beta_raw_guess", "2", 2);
        validate_non_negative_index("beta_raw_guess", "mX", mX);
        beta_raw_guess = std::vector<vector_d>(2,vector_d(static_cast<Eigen::VectorXd::Index>(mX)));
        vals_r__ = context__.vals_r("beta_raw_guess");
        pos__ = 0;
        size_t beta_raw_guess_i_vec_lim__ = mX;
        for (size_t i_vec__ = 0; i_vec__ < beta_raw_guess_i_vec_lim__; ++i_vec__) {
            size_t beta_raw_guess_limit_0__ = 2;
            for (size_t i_0__ = 0; i_0__ < beta_raw_guess_limit_0__; ++i_0__) {
                beta_raw_guess[i_0__][i_vec__] = vals_r__[pos__++];
            }
        }
        validate_non_negative_index("tau_raw_guess", "2", 2);
        context__.validate_dims("data initialization", "tau_raw_guess", "double", context__.to_vec(2));
        validate_non_negative_index("tau_raw_guess", "2", 2);
        tau_raw_guess = std::vector<double>(2,double(0));
        vals_r__ = context__.vals_r("tau_raw_guess");
        pos__ = 0;
        size_t tau_raw_guess_limit_0__ = 2;
        for (size_t i_0__ = 0; i_0__ < tau_raw_guess_limit_0__; ++i_0__) {
            tau_raw_guess[i_0__] = vals_r__[pos__++];
        }

        // validate, data variables
        check_greater_or_equal(function__,"H",H,1);
        check_greater_or_equal(function__,"link",link,1);
        check_less_or_equal(function__,"link",link,3);
        for (int k0__ = 0; k0__ < H; ++k0__) {
            check_greater_or_equal(function__,"r[k0__]",r[k0__],0);
        }
        for (int k0__ = 0; k0__ < H; ++k0__) {
            check_greater_or_equal(function__,"r_n[k0__]",r_n[k0__],1);
        }
        for (int k0__ = 0; k0__ < H; ++k0__) {
            check_greater_or_equal(function__,"count[k0__]",count[k0__],0);
        }
        check_greater_or_equal(function__,"n_groups",n_groups,1);
        check_less_or_equal(function__,"n_groups",n_groups,H);
        for (int k0__ = 0; k0__ < H; ++k0__) {
            check_greater_or_equal(function__,"group_index[k0__]",group_index[k0__],1);
            check_less_or_equal(function__,"group_index[k0__]",group_index[k0__],n_groups);
        }
        check_greater_or_equal(function__,"n_tau_strata",n_tau_strata,1);
        check_less_or_equal(function__,"n_tau_strata",n_tau_strata,n_groups);
        check_greater_or_equal(function__,"tau_strata_pred",tau_strata_pred,1);
        check_less_or_equal(function__,"tau_strata_pred",tau_strata_pred,n_tau_strata);
        for (int k0__ = 0; k0__ < n_groups; ++k0__) {
            check_greater_or_equal(function__,"tau_strata_index[k0__]",tau_strata_index[k0__],1);
            check_less_or_equal(function__,"tau_strata_index[k0__]",tau_strata_index[k0__],n_tau_strata);
        }
        check_greater_or_equal(function__,"mX",mX,1);
        check_greater_or_equal(function__,"tau_prior_dist",tau_prior_dist,-(1));
        check_less_or_equal(function__,"tau_prior_dist",tau_prior_dist,7);
        check_greater_or_equal(function__,"re_dist",re_dist,0);
        check_less_or_equal(function__,"re_dist",re_dist,1);
        check_greater_or_equal(function__,"re_dist_t_df",re_dist_t_df,0);
        check_greater_or_equal(function__,"ncp",ncp,0);
        check_less_or_equal(function__,"ncp",ncp,1);
        // initialize data variables
        validate_non_negative_index("beta_prior_stan", "2", 2);
        validate_non_negative_index("beta_prior_stan", "mX", mX);
        beta_prior_stan = std::vector<vector_d>(2,vector_d(static_cast<Eigen::VectorXd::Index>(mX)));
        stan::math::fill(beta_prior_stan,DUMMY_VAR__);
        validate_non_negative_index("tau_prior_stan", "2", 2);
        validate_non_negative_index("tau_prior_stan", "n_tau_strata", n_tau_strata);
        tau_prior_stan = std::vector<vector_d>(2,vector_d(static_cast<Eigen::VectorXd::Index>(n_tau_strata)));
        stan::math::fill(tau_prior_stan,DUMMY_VAR__);
        validate_non_negative_index("S", "n_groups", n_groups);
        validate_non_negative_index("S", "n_tau_strata", n_tau_strata);
        S = matrix_d(static_cast<Eigen::VectorXd::Index>(n_groups),static_cast<Eigen::VectorXd::Index>(n_tau_strata));
        stan::math::fill(S,DUMMY_VAR__);
        validate_non_negative_index("Z", "H", H);
        validate_non_negative_index("Z", "n_groups", n_groups);
        Z = matrix_d(static_cast<Eigen::VectorXd::Index>(H),static_cast<Eigen::VectorXd::Index>(n_groups));
        stan::math::fill(Z,DUMMY_VAR__);
        validate_non_negative_index("X_param", "H", H);
        validate_non_negative_index("X_param", "mX", mX);
        X_param = matrix_d(static_cast<Eigen::VectorXd::Index>(H),static_cast<Eigen::VectorXd::Index>(mX));
        stan::math::fill(X_param,DUMMY_VAR__);

        try {
            for (int i = 1; i <= mX; ++i) {

                stan::math::assign(get_base1_lhs(get_base1_lhs(beta_prior_stan,1,"beta_prior_stan",1),i,"beta_prior_stan",2), get_base1(beta_prior,i,1,"beta_prior",1));
                stan::math::assign(get_base1_lhs(get_base1_lhs(beta_prior_stan,2,"beta_prior_stan",1),i,"beta_prior_stan",2), get_base1(beta_prior,i,2,"beta_prior",1));
            }
            for (int i = 1; i <= n_tau_strata; ++i) {

                stan::math::assign(get_base1_lhs(get_base1_lhs(tau_prior_stan,1,"tau_prior_stan",1),i,"tau_prior_stan",2), get_base1(tau_prior,i,1,"tau_prior",1));
                stan::math::assign(get_base1_lhs(get_base1_lhs(tau_prior_stan,2,"tau_prior_stan",1),i,"tau_prior_stan",2), get_base1(tau_prior,i,2,"tau_prior",1));
            }
            stan::math::assign(S, rep_matrix(0,n_groups,n_tau_strata));
            for (int i = 1; i <= n_groups; ++i) {
                stan::math::assign(get_base1_lhs(S,i,get_base1(tau_strata_index,i,"tau_strata_index",1),"S",1), 1.0);
            }
            stan::math::assign(Z, rep_matrix(0,H,n_groups));
            for (int i = 1; i <= H; ++i) {
                stan::math::assign(get_base1_lhs(Z,i,get_base1(group_index,i,"group_index",1),"Z",1), 1.0);
            }
            if (pstream__) {
                stan_print(pstream__,"Stan gMAP analysis");
                *pstream__ << std::endl;
            }
            if (as_bool(logical_eq(link,1))) {
                if (pstream__) {
                    stan_print(pstream__,"likelihood:      Normal (identity link)");
                    *pstream__ << std::endl;
                }
            }
            if (as_bool(logical_eq(link,2))) {
                if (pstream__) {
                    stan_print(pstream__,"likelihood:      Binomial (logit link)");
                    *pstream__ << std::endl;
                }
            }
            if (as_bool(logical_eq(link,3))) {
                if (pstream__) {
                    stan_print(pstream__,"likelihood:      Poisson (log link)");
                    *pstream__ << std::endl;
                }
            }
            if (as_bool(logical_eq(tau_prior_dist,-(1)))) {
                if (pstream__) {
                    stan_print(pstream__,"tau distrib.:    Fixed");
                    *pstream__ << std::endl;
                }
            }
            if (as_bool(logical_eq(tau_prior_dist,0))) {
                if (pstream__) {
                    stan_print(pstream__,"tau distrib.:    HalfNormal");
                    *pstream__ << std::endl;
                }
            }
            if (as_bool(logical_eq(tau_prior_dist,1))) {
                if (pstream__) {
                    stan_print(pstream__,"tau distrib.:    TruncNormal");
                    *pstream__ << std::endl;
                }
            }
            if (as_bool(logical_eq(tau_prior_dist,2))) {
                if (pstream__) {
                    stan_print(pstream__,"tau distrib.:    Uniform");
                    *pstream__ << std::endl;
                }
            }
            if (as_bool(logical_eq(tau_prior_dist,3))) {
                if (pstream__) {
                    stan_print(pstream__,"tau distrib.:    Gamma");
                    *pstream__ << std::endl;
                }
            }
            if (as_bool(logical_eq(tau_prior_dist,4))) {
                if (pstream__) {
                    stan_print(pstream__,"tau distrib.:    InvGamma");
                    *pstream__ << std::endl;
                }
            }
            if (as_bool(logical_eq(tau_prior_dist,5))) {
                if (pstream__) {
                    stan_print(pstream__,"tau distrib.:    LogNormal");
                    *pstream__ << std::endl;
                }
            }
            if (as_bool(logical_eq(tau_prior_dist,6))) {
                if (pstream__) {
                    stan_print(pstream__,"tau distrib.:    TruncCauchy");
                    *pstream__ << std::endl;
                }
            }
            if (as_bool(logical_eq(tau_prior_dist,7))) {
                if (pstream__) {
                    stan_print(pstream__,"tau distrib.:    Exponential");
                    *pstream__ << std::endl;
                }
            }
            if (as_bool(logical_eq(re_dist,0))) {
                if (pstream__) {
                    stan_print(pstream__,"random effects:  Normal");
                    *pstream__ << std::endl;
                }
            }
            if (as_bool(logical_eq(re_dist,1))) {
                if (pstream__) {
                    stan_print(pstream__,"random effects:  Student-t, df = ");
                    stan_print(pstream__,re_dist_t_df);
                    *pstream__ << std::endl;
                }
            }
            if (as_bool(ncp)) {

                stan::math::assign(X_param, X);
                if (pstream__) {
                    stan_print(pstream__,"parametrization: Non-Centered");
                    *pstream__ << std::endl;
                }
            } else {

                if (pstream__) {
                    stan_print(pstream__,"parametrization: Centered");
                    *pstream__ << std::endl;
                }
                stan::math::assign(X_param, X);
                for (int i = 1; i <= H; ++i) {

                    if (as_bool(logical_neq(get_base1(X_param,i,1,"X_param",1),1))) {
                        std::stringstream errmsg_stream__;
                        errmsg_stream__ << "Centered parametrization requires treatment contrast parametrization!";
                        throw std::domain_error(errmsg_stream__.str());
                    }
                    stan::math::assign(get_base1_lhs(X_param,i,1,"X_param",1), 0);
                }
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed data

        // validate, set parameter ranges
        num_params_r__ = 0U;
        param_ranges_i__.clear();
        validate_non_negative_index("beta_raw", "mX", mX);
        num_params_r__ += mX;
        validate_non_negative_index("tau_raw", "n_tau_strata", n_tau_strata);
        num_params_r__ += n_tau_strata;
        validate_non_negative_index("xi_eta", "n_groups", n_groups);
        num_params_r__ += n_groups;
    }

    ~model_gMAP() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("beta_raw")))
            throw std::runtime_error("variable beta_raw missing");
        vals_r__ = context__.vals_r("beta_raw");
        pos__ = 0U;
        validate_non_negative_index("beta_raw", "mX", mX);
        context__.validate_dims("initialization", "beta_raw", "vector_d", context__.to_vec(mX));
        // generate_declaration beta_raw
        vector_d beta_raw(static_cast<Eigen::VectorXd::Index>(mX));
        for (int j1__ = 0U; j1__ < mX; ++j1__)
            beta_raw(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(beta_raw);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable beta_raw: ") + e.what());
        }

        if (!(context__.contains_r("tau_raw")))
            throw std::runtime_error("variable tau_raw missing");
        vals_r__ = context__.vals_r("tau_raw");
        pos__ = 0U;
        validate_non_negative_index("tau_raw", "n_tau_strata", n_tau_strata);
        context__.validate_dims("initialization", "tau_raw", "vector_d", context__.to_vec(n_tau_strata));
        // generate_declaration tau_raw
        vector_d tau_raw(static_cast<Eigen::VectorXd::Index>(n_tau_strata));
        for (int j1__ = 0U; j1__ < n_tau_strata; ++j1__)
            tau_raw(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(tau_raw);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable tau_raw: ") + e.what());
        }

        if (!(context__.contains_r("xi_eta")))
            throw std::runtime_error("variable xi_eta missing");
        vals_r__ = context__.vals_r("xi_eta");
        pos__ = 0U;
        validate_non_negative_index("xi_eta", "n_groups", n_groups);
        context__.validate_dims("initialization", "xi_eta", "vector_d", context__.to_vec(n_groups));
        // generate_declaration xi_eta
        vector_d xi_eta(static_cast<Eigen::VectorXd::Index>(n_groups));
        for (int j1__ = 0U; j1__ < n_groups; ++j1__)
            xi_eta(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(xi_eta);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable xi_eta: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        T__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        // model parameters
        stan::io::reader<T__> in__(params_r__,params_i__);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  beta_raw;
        (void) beta_raw;  // dummy to suppress unused var warning
        if (jacobian__)
            beta_raw = in__.vector_constrain(mX,lp__);
        else
            beta_raw = in__.vector_constrain(mX);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  tau_raw;
        (void) tau_raw;  // dummy to suppress unused var warning
        if (jacobian__)
            tau_raw = in__.vector_constrain(n_tau_strata,lp__);
        else
            tau_raw = in__.vector_constrain(n_tau_strata);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  xi_eta;
        (void) xi_eta;  // dummy to suppress unused var warning
        if (jacobian__)
            xi_eta = in__.vector_constrain(n_groups,lp__);
        else
            xi_eta = in__.vector_constrain(n_groups);


        // transformed parameters
        validate_non_negative_index("theta", "H", H);
        Eigen::Matrix<T__,Eigen::Dynamic,1>  theta(static_cast<Eigen::VectorXd::Index>(H));
        (void) theta;  // dummy to suppress unused var warning

        stan::math::initialize(theta, DUMMY_VAR__);
        stan::math::fill(theta,DUMMY_VAR__);
        validate_non_negative_index("eta", "n_groups", n_groups);
        Eigen::Matrix<T__,Eigen::Dynamic,1>  eta(static_cast<Eigen::VectorXd::Index>(n_groups));
        (void) eta;  // dummy to suppress unused var warning

        stan::math::initialize(eta, DUMMY_VAR__);
        stan::math::fill(eta,DUMMY_VAR__);
        validate_non_negative_index("beta", "mX", mX);
        Eigen::Matrix<T__,Eigen::Dynamic,1>  beta(static_cast<Eigen::VectorXd::Index>(mX));
        (void) beta;  // dummy to suppress unused var warning

        stan::math::initialize(beta, DUMMY_VAR__);
        stan::math::fill(beta,DUMMY_VAR__);
        validate_non_negative_index("tau", "n_tau_strata", n_tau_strata);
        Eigen::Matrix<T__,Eigen::Dynamic,1>  tau(static_cast<Eigen::VectorXd::Index>(n_tau_strata));
        (void) tau;  // dummy to suppress unused var warning

        stan::math::initialize(tau, DUMMY_VAR__);
        stan::math::fill(tau,DUMMY_VAR__);


        try {
            stan::math::assign(beta, add(get_base1(beta_raw_guess,1,"beta_raw_guess",1),elt_multiply(get_base1(beta_raw_guess,2,"beta_raw_guess",1),beta_raw)));
            if (as_bool(logical_eq(tau_prior_dist,-(1)))) {
                stan::math::assign(tau, get_base1(tau_prior_stan,1,"tau_prior_stan",1));
            } else {
                stan::math::assign(tau, exp(add(get_base1(tau_raw_guess,1,"tau_raw_guess",1),multiply(get_base1(tau_raw_guess,2,"tau_raw_guess",1),tau_raw))));
            }
            if (as_bool(ncp)) {
                stan::math::assign(eta, elt_multiply(xi_eta,multiply(S,tau)));
            } else {
                stan::math::assign(eta, add(get_base1(get_base1(beta_raw_guess,1,"beta_raw_guess",1),1,"beta_raw_guess",2),multiply(get_base1(get_base1(beta_raw_guess,2,"beta_raw_guess",1),1,"beta_raw_guess",2),xi_eta)));
            }
            stan::math::assign(theta, add(multiply(X_param,beta),multiply(Z,eta)));
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters
        for (int i0__ = 0; i0__ < H; ++i0__) {
            if (stan::math::is_uninitialized(theta(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: theta" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }
        for (int i0__ = 0; i0__ < n_groups; ++i0__) {
            if (stan::math::is_uninitialized(eta(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: eta" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }
        for (int i0__ = 0; i0__ < mX; ++i0__) {
            if (stan::math::is_uninitialized(beta(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: beta" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }
        for (int i0__ = 0; i0__ < n_tau_strata; ++i0__) {
            if (stan::math::is_uninitialized(tau(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: tau" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }

        const char* function__ = "validate transformed params";
        (void) function__;  // dummy to suppress unused var warning

        // model body
        try {

            if (as_bool(ncp)) {

                if (as_bool(logical_eq(re_dist,0))) {
                    lp_accum__.add(normal_log<propto__>(xi_eta, 0, 1));
                }
                if (as_bool(logical_eq(re_dist,1))) {
                    lp_accum__.add(student_t_log<propto__>(xi_eta, re_dist_t_df, 0, 1));
                }
            } else {

                if (as_bool(logical_eq(re_dist,0))) {
                    lp_accum__.add(normal_log<propto__>(xi_eta, ((get_base1(beta,1,"beta",1) - get_base1(get_base1(beta_raw_guess,1,"beta_raw_guess",1),1,"beta_raw_guess",2)) / get_base1(get_base1(beta_raw_guess,2,"beta_raw_guess",1),1,"beta_raw_guess",2)), multiply(S,divide(tau,get_base1(get_base1(beta_raw_guess,2,"beta_raw_guess",1),1,"beta_raw_guess",2)))));
                }
                if (as_bool(logical_eq(re_dist,1))) {
                    lp_accum__.add(student_t_log<propto__>(xi_eta, re_dist_t_df, ((get_base1(beta,1,"beta",1) - get_base1(get_base1(beta_raw_guess,1,"beta_raw_guess",1),1,"beta_raw_guess",2)) / get_base1(get_base1(beta_raw_guess,2,"beta_raw_guess",1),1,"beta_raw_guess",2)), multiply(S,divide(tau,get_base1(get_base1(beta_raw_guess,2,"beta_raw_guess",1),1,"beta_raw_guess",2)))));
                }
            }
            lp_accum__.add(normal_log<propto__>(beta, get_base1(beta_prior_stan,1,"beta_prior_stan",1), get_base1(beta_prior_stan,2,"beta_prior_stan",1)));
            if (as_bool(logical_eq(tau_prior_dist,-(1)))) {
                lp_accum__.add(normal_log<propto__>(tau_raw, 0, 1));
            }
            if (as_bool(logical_eq(tau_prior_dist,0))) {
                lp_accum__.add(normal_log<propto__>(tau, 0, get_base1(tau_prior_stan,2,"tau_prior_stan",1)));
            }
            if (as_bool(logical_eq(tau_prior_dist,1))) {
                lp_accum__.add(normal_log<propto__>(tau, get_base1(tau_prior_stan,1,"tau_prior_stan",1), get_base1(tau_prior_stan,2,"tau_prior_stan",1)));
            }
            if (as_bool(logical_eq(tau_prior_dist,2))) {
                lp_accum__.add(uniform_log<propto__>(tau, get_base1(tau_prior_stan,1,"tau_prior_stan",1), get_base1(tau_prior_stan,2,"tau_prior_stan",1)));
            }
            if (as_bool(logical_eq(tau_prior_dist,3))) {
                lp_accum__.add(gamma_log<propto__>(tau, get_base1(tau_prior_stan,1,"tau_prior_stan",1), get_base1(tau_prior_stan,2,"tau_prior_stan",1)));
            }
            if (as_bool(logical_eq(tau_prior_dist,4))) {
                lp_accum__.add(inv_gamma_log<propto__>(tau, get_base1(tau_prior_stan,1,"tau_prior_stan",1), get_base1(tau_prior_stan,2,"tau_prior_stan",1)));
            }
            if (as_bool(logical_eq(tau_prior_dist,5))) {
                lp_accum__.add(lognormal_log<propto__>(tau, get_base1(tau_prior_stan,1,"tau_prior_stan",1), get_base1(tau_prior_stan,2,"tau_prior_stan",1)));
            }
            if (as_bool(logical_eq(tau_prior_dist,6))) {
                lp_accum__.add(cauchy_log<propto__>(tau, get_base1(tau_prior_stan,1,"tau_prior_stan",1), get_base1(tau_prior_stan,2,"tau_prior_stan",1)));
            }
            if (as_bool(logical_eq(tau_prior_dist,7))) {
                lp_accum__.add(exponential_log<propto__>(tau, get_base1(tau_prior_stan,1,"tau_prior_stan",1)));
            }
            if (as_bool(logical_neq(tau_prior_dist,-(1)))) {
                lp_accum__.add(multiply(get_base1(tau_raw_guess,2,"tau_raw_guess",1),tau_raw));
            }
            if (as_bool(logical_eq(link,1))) {
                lp_accum__.add(normal_log<propto__>(y, theta, y_se));
            }
            if (as_bool(logical_eq(link,2))) {
                lp_accum__.add(binomial_logit_log<propto__>(r, r_n, theta));
            }
            if (as_bool(logical_eq(link,3))) {
                lp_accum__.add(poisson_log_log<propto__>(count, add(offset,theta)));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("beta_raw");
        names__.push_back("tau_raw");
        names__.push_back("xi_eta");
        names__.push_back("theta");
        names__.push_back("eta");
        names__.push_back("beta");
        names__.push_back("tau");
        names__.push_back("theta_pred");
        names__.push_back("theta_resp_pred");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(mX);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n_tau_strata);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n_groups);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(H);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n_groups);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(mX);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n_tau_strata);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        vars__.resize(0);
        stan::io::reader<double> in__(params_r__,params_i__);
        static const char* function__ = "model_gMAP_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        vector_d beta_raw = in__.vector_constrain(mX);
        vector_d tau_raw = in__.vector_constrain(n_tau_strata);
        vector_d xi_eta = in__.vector_constrain(n_groups);
        for (int k_0__ = 0; k_0__ < mX; ++k_0__) {
            vars__.push_back(beta_raw[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < n_tau_strata; ++k_0__) {
            vars__.push_back(tau_raw[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < n_groups; ++k_0__) {
            vars__.push_back(xi_eta[k_0__]);
        }

        if (!include_tparams__) return;
        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;

        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        validate_non_negative_index("theta", "H", H);
        vector_d theta(static_cast<Eigen::VectorXd::Index>(H));
        (void) theta;  // dummy to suppress unused var warning

        stan::math::initialize(theta, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(theta,DUMMY_VAR__);
        validate_non_negative_index("eta", "n_groups", n_groups);
        vector_d eta(static_cast<Eigen::VectorXd::Index>(n_groups));
        (void) eta;  // dummy to suppress unused var warning

        stan::math::initialize(eta, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(eta,DUMMY_VAR__);
        validate_non_negative_index("beta", "mX", mX);
        vector_d beta(static_cast<Eigen::VectorXd::Index>(mX));
        (void) beta;  // dummy to suppress unused var warning

        stan::math::initialize(beta, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(beta,DUMMY_VAR__);
        validate_non_negative_index("tau", "n_tau_strata", n_tau_strata);
        vector_d tau(static_cast<Eigen::VectorXd::Index>(n_tau_strata));
        (void) tau;  // dummy to suppress unused var warning

        stan::math::initialize(tau, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(tau,DUMMY_VAR__);


        try {
            stan::math::assign(beta, add(get_base1(beta_raw_guess,1,"beta_raw_guess",1),elt_multiply(get_base1(beta_raw_guess,2,"beta_raw_guess",1),beta_raw)));
            if (as_bool(logical_eq(tau_prior_dist,-(1)))) {
                stan::math::assign(tau, get_base1(tau_prior_stan,1,"tau_prior_stan",1));
            } else {
                stan::math::assign(tau, exp(add(get_base1(tau_raw_guess,1,"tau_raw_guess",1),multiply(get_base1(tau_raw_guess,2,"tau_raw_guess",1),tau_raw))));
            }
            if (as_bool(ncp)) {
                stan::math::assign(eta, elt_multiply(xi_eta,multiply(S,tau)));
            } else {
                stan::math::assign(eta, add(get_base1(get_base1(beta_raw_guess,1,"beta_raw_guess",1),1,"beta_raw_guess",2),multiply(get_base1(get_base1(beta_raw_guess,2,"beta_raw_guess",1),1,"beta_raw_guess",2),xi_eta)));
            }
            stan::math::assign(theta, add(multiply(X_param,beta),multiply(Z,eta)));
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters

        // write transformed parameters
        for (int k_0__ = 0; k_0__ < H; ++k_0__) {
            vars__.push_back(theta[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < n_groups; ++k_0__) {
            vars__.push_back(eta[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < mX; ++k_0__) {
            vars__.push_back(beta[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < n_tau_strata; ++k_0__) {
            vars__.push_back(tau[k_0__]);
        }

        if (!include_gqs__) return;
        // declare and define generated quantities
        double theta_pred(0.0);
        (void) theta_pred;  // dummy to suppress unused var warning

        stan::math::initialize(theta_pred, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(theta_pred,DUMMY_VAR__);
        double theta_resp_pred(0.0);
        (void) theta_resp_pred;  // dummy to suppress unused var warning

        stan::math::initialize(theta_resp_pred, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(theta_resp_pred,DUMMY_VAR__);


        try {
            if (as_bool(logical_eq(re_dist,0))) {
                stan::math::assign(theta_pred, normal_rng(get_base1(beta,1,"beta",1),get_base1(tau,tau_strata_pred,"tau",1), base_rng__));
            }
            if (as_bool(logical_eq(re_dist,1))) {
                stan::math::assign(theta_pred, student_t_rng(re_dist_t_df,get_base1(beta,1,"beta",1),get_base1(tau,tau_strata_pred,"tau",1), base_rng__));
            }
            if (as_bool(logical_eq(link,1))) {
                stan::math::assign(theta_resp_pred, theta_pred);
            }
            if (as_bool(logical_eq(link,2))) {
                stan::math::assign(theta_resp_pred, inv_logit(theta_pred));
            }
            if (as_bool(logical_eq(link,3))) {
                stan::math::assign(theta_resp_pred, exp(theta_pred));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate generated quantities

        // write generated quantities
        vars__.push_back(theta_pred);
        vars__.push_back(theta_resp_pred);

    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "model_gMAP";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= mX; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta_raw" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= n_tau_strata; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "tau_raw" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= n_groups; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "xi_eta" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= H; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "theta" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= n_groups; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "eta" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= mX; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= n_tau_strata; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "tau" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
        param_name_stream__.str(std::string());
        param_name_stream__ << "theta_pred";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "theta_resp_pred";
        param_names__.push_back(param_name_stream__.str());
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= mX; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta_raw" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= n_tau_strata; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "tau_raw" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= n_groups; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "xi_eta" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= H; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "theta" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= n_groups; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "eta" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= mX; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= n_tau_strata; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "tau" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
        param_name_stream__.str(std::string());
        param_name_stream__ << "theta_pred";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "theta_resp_pred";
        param_names__.push_back(param_name_stream__.str());
    }

}; // model

}




#endif
