% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RBF-fn.R
\name{backf.l2.cv}
\alias{backf.l2.cv}
\title{Cross-validation for the Classical Backfitting algorithm}
\usage{
backf.l2.cv(k = 5, Xp, yp, windows, epsilon = 1e-06, degree,
  seed = 123, max.it = 50)
}
\arguments{
\item{k}{a positive integer indicating the number of folds.}

\item{Xp}{a matrix (n x p) containing the explanatory variables}

\item{yp}{vector of responses (missing values are allowed)}

\item{windows}{vector of bandwidths for the local polynomial smoother,
one per explanatory variable.}

\item{epsilon}{convergence criterion. Maximum allowed relative difference between
consecutive estimates}

\item{degree}{degree of the local polynomial smoother. Defaults to \code{0} (local constant).}

\item{seed}{an integer used to set the seed of the pseudo-number generator that
creates the \code{k} folds.}

\item{max.it}{Maximum number of iterations for the algorithm.}
}
\value{
A real number with the mean squared (hold-out) prediction error
}
\description{
This function performs one run of K-fold cross-validation using the
classical backfitting algorithm.
}
\details{
This function performs one run of K-fold cross-validation using the
classical backfitting algorithm and returns the mean squared
hold out prediction error.
}
\examples{
data(airquality)
x <- airquality
x <- x[complete.cases(x), c('Ozone', 'Solar.R', 'Wind', 'Temp')]
y <- as.vector(x$Ozone)
x <- as.matrix(x[, c('Solar.R', 'Wind', 'Temp')])
backf.l2.cv(k=5, Xp = x, yp=y, windows=c(130, 9, 10), degree=1)

}
\author{
Matias Salibian-Barrera, \email{matias@stat.ubc.ca}, Alejandra Martinez
}
