% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SEU_BINARY_raw.R
\name{SEU_BINARY_raw}
\alias{SEU_BINARY_raw}
\title{Sequential Estimation-adjusted Urn Model (Binary Data)}
\usage{
SEU_BINARY_raw(x.df, urn_comp, arms, group_allo, add_rule_index,
add_rule)
}
\arguments{
\item{x.df}{A data frame of two columns: treatment arm and response value.}

\item{urn_comp}{A vector of current urn composition.}

\item{arms}{A vector of arm names. If it is not provided, the arms occurred
in x.df will be assumed as all possible arms. Suggest to always assign arms.}

\item{group_allo}{An integer of the size of group allocation. The default is
1.}

\item{add_rule_index}{Supply a number of 1, 2 or 3 indicting the
addition rules to target allocation functions.
1 = randomized play-the-winner (RPW) rule that targets the urn allocation
2 = the SEU model that targets Neyman allocation;
3 = the SEU model that targets Rosenberger allocation;'
4 = the SEU model that assigns probability of 0.6+1/K to winner at each step.
The default is 1.}

\item{add_rule}{Supply a user-specified addition rules function of x.df and
arms when add_rule_index is NULL. Default is NULL.}
}
\value{
Code of arms that the next group of subjects assigned to and the
updated urn composition.
}
\description{
Allocates patients to one of treatments based on sequential
estimation-adjusted urn model (SEU) on summarized data.
}
\details{
'SEU_BINARY_raw' assigns the next subject to a group given the
observed data, current urn composition, full list of arm codes,
number of group allocation and addition rule function.
}
\examples{
x.df = data.frame(
ARM = sample(LETTERS[1:3],50,replace = TRUE),
RESPONSE = sample(c(0,1),50,replace = TRUE)
)
SEU_BINARY_raw(x.df, urn_comp=c(0,0,0), arms=c("A","B","C"))

x.df = data.frame(
ARM = sample(LETTERS[1:2],40,replace = TRUE),
RESPONSE = sample(c(0,1),40,replace = TRUE)
)
SEU_BINARY_raw(x.df,
urn_comp=c(0,0),
arms=c("A","B"),
group_allo = 1,
add_rule_index = 3)

}
