% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rc.expand.sample.names.R
\name{rc.expand.sample.names}
\alias{rc.expand.sample.names}
\title{rc.expand.sample.names}
\usage{
rc.expand.sample.names(
  ramclustObj = NULL,
  delim = "-",
  factor.names = TRUE,
  quiet = FALSE
)
}
\arguments{
\item{ramclustObj}{ramclustObj containing MSdata with optional MSMSdata (MSe, DIA, idMSMS)}

\item{delim}{what delimiter should be used to separate names into factors?  '-' by default}

\item{factor.names}{logical or character vector.  if TRUE, user will enter names one by on in console.  If character vector (i.e. c("trt", "time")) names are assigned to table}

\item{quiet}{logical .  if TRUE, user will not be prompted to enter names one by on in console.}
}
\value{
ramclustR object with normalized data.
}
\description{
turn concatenated sample names into factors
}
\details{
THis function only works on newer format ramclustObjects with a $phenoData slot.

This function will split sample names by a delimiter, and enable users to name factors
}
\references{
Broeckling CD, Afsar FA, Neumann S, Ben-Hur A, Prenni JE. RAMClust: a novel feature clustering method enables spectral-matching-based annotation for metabolomics data. Anal Chem. 2014 Jul 15;86(14):6812-7. doi: 10.1021/ac501530d.  Epub 2014 Jun 26. PubMed PMID: 24927477.
}
\author{
Corey Broeckling
}
\concept{MSFinder}
\concept{RAMClustR}
\concept{clustering}
\concept{feature}
\concept{mass spectrometry}
\concept{metabolomics}
\concept{ramclustR}
\concept{xcms}
