% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findfeature.R
\name{findfeature}
\alias{findfeature}
\title{findfeature}
\usage{
findfeature(
  ramclustObj = NULL,
  mz = NULL,
  mztol = 0.02,
  rt = NULL,
  rttol = 2,
  iso.rttol = 2,
  zmax = 6,
  m.check = TRUE
)
}
\arguments{
\item{ramclustObj}{R object: the ramclustR object to explore}

\item{mz}{numeric: mz value to search for}

\item{mztol}{numeric: absolute mass tolerance around mz}

\item{rt}{numeric: optional rt value to search for (generally in seconds, though use whatever units your data is in)}

\item{rttol}{numeric: absolute retention time tolerance around rt.}

\item{iso.rttol}{numeric: when examining isotope patterns, feature retention time tolerance around features matching mz +- mztol}

\item{zmax}{integer: maximum charge state to consider.  default is 6.}

\item{m.check}{logical:  check whether the matching masses are plausibly M0.  That is, we look for ions 1 proton mass (from charge state 1:zmax) below the target m/z at the same time that have intensities consistent with target ion being a non-M0 isotope.}
}
\value{
returns a table to the console listing masses which match, their retention time and intensity, and whether it appears to be plausible as M0
}
\description{
see if any features match a given mass, and whether they are plausibly M0
}
\details{
a convenience function to perform a targeted search of all features for a mass of interest.  Also performs a crude plausibility check as to whether the matched feature could be M0, based on the assumption of approximately 1 carbon per 17 m/z units and natural isotopic abundance of 1.1% 13C.  Note that this function returns the cluster to which the feature is assigned, but that the M0_plausibility is independent of cluster membership.
}
\author{
Corey Broeckling
}
\concept{MSFinder}
\concept{RAMClustR}
\concept{clustering}
\concept{feature}
\concept{mass spectrometry}
\concept{metabolomics}
\concept{ramclustR}
\concept{xcms}
