% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/R62S3.R
\name{R62S3}
\alias{R62S3}
\title{S3 Method Generator from R6 Class}
\usage{
R62S3(R6Class, dispatchClasses = list(R6Class),
  assignEnvir = parent.env(environment()), mask = FALSE)
}
\arguments{
\item{R6Class}{R6ClassGenerator to generate public methods from}

\item{dispatchClasses}{list of classes to assign S3 dispatch methods on}

\item{assignEnvir}{environment in which to assign the S3 generics/methods, default is parent of current environment.}

\item{mask}{logical, determines if non-generic functions should be masked if found, see details.}
}
\value{
Assigns methods and generics to the chosen environment.
}
\description{
Auto-generates S3 generics and public methods from an R6 Class.
}
\details{
Searches in a given R6 class for all public methods that are not 'initialize' or 'clone'.
For each method if a generic does not already exist, one is created and assigned to the given environment.
Methods are created for every generic, following standard S3 convention.

In some cases a function may be defined without being a generic, if mask is TRUE then this function
is masked by R62S3 and a generic is created with the same name. If mask is FALSE then this function
is treated like a generic and only the method is created.
}
\examples{
printMachine <- R6::R6Class("printMachine",
public = list(initialize = function() {},
printer = function(str) {print(str)}))
pm <- printMachine$new()
R62S3(printMachine, assignEnvir = .GlobalEnv)
pm$printer("Test String A")
printer(pm, "Test String B")

}
