% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ltx_list.r
\name{ltx_list}
\alias{ltx_list}
\title{Creates a latex listing}
\usage{
ltx_list(
  dfrm,
  vars = names(dfrm),
  fill = "",
  vargroup = NULL,
  porder = TRUE,
  uselabel = TRUE,
  footnote = "",
  tablenote = "",
  mancol = NULL,
  size = "\\\\footnotesize",
  title = "listing",
  titlepr = NULL,
  group = NULL,
  xrepeat = FALSE,
  hyper = TRUE,
  out = NULL,
  rawout = paste0(out, ".rawtex"),
  convchar = TRUE,
  tabenv = "longtable",
  label = NULL,
  ...
)
}
\arguments{
\item{dfrm}{the data frame to be prepared}

\item{vars}{character vector that defines the variables within the data frame to be placed in the listing}

\item{fill}{character vector of one indicating the character to use in case of missing values}

\item{vargroup}{a vector of the same length as vars. Creates a first line in the table to group variables (see details)}

\item{porder}{logical indicating if the data frame should be ordered on the variables given in vars}

\item{uselabel}{logical indicating if labels should be used for the x variable(s).
If set to TRUE, the function will try to use the label attribute for the display of x variable(s).}

\item{footnote}{character string with the footnote to be placed in the footer of the page (LaTeX coding can be used for example to create line breaks)}

\item{tablenote}{character string with the table note to be placed directly below the table (LaTeX coding can be used for example to create line breaks)}

\item{mancol}{character string to define manual column alignment. in case argument is NULL, a sensible default will be set.}

\item{size}{character string to define the font size of the table}

\item{title}{character string to define the title of the table which will be added to the caption}

\item{titlepr}{character string to define the prefix of the table title. Can be used to create custom table numbering}

\item{group}{number indicating which x variables should be grouped (displayed in table with a certain white space) and interpreted as x[1:group]}

\item{xrepeat}{logical indicating if duplicate x values should be repeated in the table or not}

\item{hyper}{logical indicating if a hypertarget should be set used for bookmarks}

\item{out}{filename for the output latex file (if NULL it will print to console)}

\item{rawout}{character string with the name of the raw latex file to generate (e.g. only listing with no preamble and document ending)
In case NULL no raw output will be generated. In order to combine results the filename should end in .rawtex}

\item{convchar}{logical indicating if special characters should be masked}

\item{tabenv}{character with the table environment to use. Currently "longtable" and "tabular" are supported}

\item{label}{character with the label to add after the caption for referencing the table in text}

\item{...}{additional arguments passed through to \code{\link{ltx_doc}}. Most important are template, rendlist, compile and show}
}
\value{
The function returns a latex file (or writes output to console)
}
\description{
This function creates a latex listing which can be written to a file or console
}
\details{
The vargroup argument should be provided in the following form: \cr
  \code{c(rep("",4),rep("group1",3),rep("group2",4))}.
  The function will place the text within the vector with the given length as first line in the table with a midrule below it.
  an exception is made for empty strings.
}
\examples{

\dontrun{
  data(Theoph)
  grp <- c(rep("",3),rep("grouped variables",2))
  ltx_list(Theoph,out=tempfile(fileext=".tex"),vargroup=grp,
           template=paste0(system.file(package="R3port"),"/listing.tex"))
}
}
