% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/twosample_test.R
\name{twosample_test}
\alias{twosample_test}
\title{This function runs a number of two sample tests using Rcpp and parallel computing.}
\usage{
twosample_test(
  x,
  y,
  vals,
  B = 5000,
  nbins = c(100, 10),
  maxProcessor = 10,
  discretize = FALSE,
  doMethod
)
}
\arguments{
\item{x}{a vector of numbers if data is contiunous or of counts  if data is discrete.}

\item{y}{a vector of numbers if data is contiunous or of counts  if data is discrete.}

\item{vals}{a vector of numbers, the values of a discrete random variable. If it is missing, continuous data is assumed.}

\item{B}{=5000, number of simulation runs for permutation test}

\item{nbins}{=c(100,10), number of bins for chi square tests.}

\item{maxProcessor}{=10, maximum number of cores to use. If maxProcessor=1 no parallel computing is used.}

\item{discretize}{=FALSE. Should continuous data be binned?}

\item{doMethod}{Which methods should be included? If missing default methods are used.}
}
\value{
A list of two numeric vectors, the test statistics and the p values.
}
\description{
This function runs a number of two sample tests using Rcpp and parallel computing.
}
\examples{
 twosample_test(rnorm(1000), rt(1000, 4), B=1000, maxProcessor = 1)
 vals=1:5
 x=table(sample(vals, size=100, replace=TRUE))
 y=table(sample(vals, size=100, replace=TRUE, prob=c(1,1,2,1,1)))
 twosample_test(x, y, vals, maxProcessor = 1)
}
