% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parametric_fits.R
\name{low.integrate}
\alias{low.integrate}
\title{Function to estimate the area under a curve given as x and y(x) values}
\usage{
low.integrate(x, y)
}
\arguments{
\item{x}{Numeric vector of x values.}

\item{y}{Numeric vector of y values with the same length as \code{x}.}
}
\value{
Numeric value: Area under the smoothed spline.
}
\description{
Function to estimate the area under a curve given as x and y(x) values
}
\details{
The function uses the the R internal function \code{\link{smooth.spline}}.
}
\examples{
# Create random growth dataset
rnd.dataset <- rdm.data(d = 35, mu = 0.8, A = 5, label = 'Test1')

# Extract time and growth data for single sample
time <- rnd.dataset$time[1,]
data <- as.numeric(rnd.dataset$data[1,-(1:3)]) # Remove identifier columns

plot(time, data)

print(low.integrate(time, data))

}
\seealso{
\code{\link{smooth.spline}}
}
