% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fluorescence_plots.R
\name{plot.drFitfl}
\alias{plot.drFitfl}
\title{Generic plot function for \code{drFitFL} objects.}
\usage{
\method{plot}{drFitfl}(
  x,
  ec50line = TRUE,
  log = c("xy"),
  pch = 1,
  broken = TRUE,
  bp,
  n.xbreaks,
  n.ybreaks,
  colSpline = 1,
  colData = 1,
  cex.point = 1,
  cex.lab = 1.5,
  cex.axis = 1.3,
  y.lim = NULL,
  x.lim = NULL,
  lwd = 2,
  plot = TRUE,
  export = FALSE,
  height = 7,
  width = 9,
  out.dir = NULL,
  ...
)
}
\arguments{
\item{x}{object of class \code{drFit}, created with \code{\link{growth.drFit}}.}

\item{ec50line}{(Logical) Show pointed horizontal and vertical lines at the EC50 values (\code{TRUE}) or not (\code{FALSE}).}

\item{log}{(Character) String which contains '"x"' if the x axis is to be logarithmic, '"y"' if the y axis is to be logarithmic and '"xy"' or '"yx"' if both axes are to be logarithmic. The default is "x". The empty string "" yields the original axes.}

\item{pch}{(Numeric) Shape of the raw data symbols.}

\item{broken}{(Logical) If TRUE the x axis is broken provided this axis is logarithmic (using functionality in the CRAN package 'plotrix').}

\item{bp}{(Numeric) Specifying the break point below which the dose is zero (the amount of stretching on the dose axis above zero in order to create the visual illusion of a logarithmic scale including 0). The default is the base-10 value corresponding to the rounded value of the minimum of the log10 values of all positive dose values. This argument is only working for logarithmic dose axes.}

\item{n.xbreaks}{(Numeric) Number of breaks on the x-axis (if not log-transformed). The breaks are generated using \code{pretty}. Thus, the final number of breaks can deviate from the user input.}

\item{n.ybreaks}{(Numeric) Number of breaks on the y-axis (if not log-transformed). The breaks are generated using \code{pretty}. Thus, the final number of breaks can deviate from the user input.}

\item{colSpline}{(Numeric or character) Spline line colour.}

\item{colData}{(Numeric or character) Contour color of the raw data circles.}

\item{cex.point}{(Numeric) Size of the raw data points.}

\item{cex.lab}{(Numeric) Font size of axis titles.}

\item{cex.axis}{(Numeric) Font size of axis annotations.}

\item{y.lim}{(Numeric vector with two elements) Optional: Provide the lower (\code{l}) and upper (\code{u}) bounds on the y-axis as a vector in the form \code{c(l, u)}. If only the lower or upper bound should be fixed, provide \code{c(l, NA)} or \code{c(NA, u)}, respectively.}

\item{x.lim}{(Numeric vector with two elements) Optional: Provide the lower (\code{l}) and upper (\code{u}) bounds on the x-axis as a vector in the form \code{c(l, u)}. If only the lower or upper bound should be fixed, provide \code{c(l, NA)} or \code{c(NA, u)}, respectively.}

\item{lwd}{(Numeric) Line width of the individual splines.}

\item{plot}{(Logical) Show the generated plot in the \code{Plots} pane (\code{TRUE}) or not (\code{FALSE}).}

\item{export}{(Logical) Export the generated plot as PDF and PNG files (\code{TRUE}) or not (\code{FALSE}).}

\item{height}{(Numeric) Height of the exported image in inches.}

\item{width}{(Numeric) Width of the exported image in inches.}

\item{out.dir}{(Character) Name or path to a folder in which the exported files are stored. If \code{NULL}, a "Plots" folder is created in the current working directory to store the files in.}

\item{...}{Additional arguments. This has currently no effect and is only meant to fulfill the requirements of a generic function.}
}
\value{
One plot per condition tested in the dose-response analysis (\code{\link{fl.drFit}} with \code{control = fl.control(dr.method = "model")}).
}
\description{
code{drFitfl} calls \code{\link{plot.drFitFLModel}} for each group used in a dose-response analysis with \code{dr.method = "model"}
}
\examples{
# load example dataset
input <- read_data(data.growth = system.file("lac_promoters.xlsx", package = "QurvE"),
                   data.fl = system.file("lac_promoters.xlsx", package = "QurvE"),
                   sheet.growth = 1,
                   sheet.fl = 2 )

# Define fit controls
control <- fl.control(fit.opt = "s",
             x_type = "time", norm_fl = TRUE,
             dr.parameter = "max_slope.spline",
             dr.method = "model",
             suppress.messages = TRUE)

# Run curve fitting workflow
res <- flFit(fl_data = input$norm.fluorescence,
             time = input$time,
             parallelize = FALSE,
             control = control)

# Perform dose-response analysis with biosensor model
drFitfl <- fl.drFit(flTable = res$flTable, control = control)

plot(drFitfl)

}
