% Generated by roxygen2 (4.0.2): do not edit by hand
\name{ibga}
\alias{ibga}
\title{Extract IBGA results from a "qualint" object}
\usage{
ibga(x)
}
\arguments{
\item{x}{a qualint object}
}
\value{
A numeric matrix depending on \code{scale} (see above).
}
\description{
Extract the testing results of IBGA from a "qualint" object. Only available
when \code{test = "IBGA"}. Produce an error signal if \code{test = "LRT"}.
}
\details{
This function extracts the results related with the IBGA graph from a "qualint"
object, which is a matrix which contains the estimating and testing information
of the treatment effects (see examples). FOr continuous responses, it is the
mean difference. For binary responses, it is the risk difference, relative risk
or odds ratio. For survival responses, it it hazard ratio.
}
\examples{
ynorm <- rnorm(300)
trtment <- sample(c(0, 1), 300, prob = c(0.4, 0.6),
                  replace = TRUE)
subgrp <- sample(c(0, 1, 2), 300, prob = c(1/3, 1/3, 1/3),
                 replace = TRUE)
test1 <- qualint(ynorm, trtment, subgrp)
ibga(test1)
}
\author{
Lixi Yu, Eun-Young Suh, Guohua (James) Pan \cr
Maintainer: Lixi Yu \email{lixi-yu@uiowa.edu}
}
\references{
Gail and Simon (1985), Testing for qualitative interactions between
treatment effects and patient subsets, Biometrics, 41, 361-372.

Pan and Wolfe (1993), Tests for generalized problems of detecting
qualitative interaction, Technical Report No. 526, Department of Statistics,
The Ohio State University.

Pan and Wolfe (1997), Test for qualitative interaction of clinical
significance, Statistics in Medicine, 16, 1645-1652.
}
\seealso{
\code{\link{coef.qualint}}
}

