% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EM.MIMv.R
\name{EM.MIMv}
\alias{EM.MIMv}
\title{EM Algorithm for QTL MIM with Asymptotic Variance-Covariance Matrix}
\usage{
EM.MIMv(
  QTL,
  marker,
  geno,
  D.matrix,
  cp.matrix = NULL,
  y,
  type = "RI",
  ng = 2,
  cM = TRUE,
  E.vector0 = NULL,
  X = NULL,
  beta0 = NULL,
  variance0 = NULL,
  crit = 10^-5,
  stop = 1000,
  conv = TRUE,
  var.pos = TRUE,
  console = TRUE
)
}
\arguments{
\item{QTL}{matrix. A q*2 matrix contains the QTL information, where
the row dimension q is the number of QTLs in the chromosomes. The
first column labels the chromosomes where the QTLs are located, and
the second column labels the positions of QTLs (in morgan (M) or
centimorgan (cM)). Note that chromosome and position must be divided
in order.}

\item{marker}{matrix. A k*2 matrix contains the marker information,
where the row dimension k is the number of markers in the chromosomes.
The first column labels the chromosomes where the markers are located,
and the second column labels the positions of QTLs (in morgan (M) or
centimorgan (cM)). Note that chromosomes and positions must be divided
in order.}

\item{geno}{matrix. A n*k matrix contains the k markers of the n
individuals. The marker genotypes of P1 homozygote (MM),
heterozygote (Mm), and P2 homozygote (mm) are coded as 2, 1, and 0,
respectively, and NA for missing value.}

\item{D.matrix}{matrix. The design matrix of QTL effects which is a
g*p matrix, where g is the number of possible QTL genotypes, and p
is the number of effects considered in the MIM model. The design
matrix can be easily generated by the function D.make().}

\item{cp.matrix}{matrix. The conditional probability matrix is an
n*g matrix, where n is the number of individuals who are genotyped,
and g is the number of possible genotypes of QTLs. If cp.matrix=NULL,
the function will calculate the conditional probability matrix.}

\item{y}{vector. A vector with n elements that contain the phenotype
values of individuals.}

\item{type}{character. The population type of the dataset. Include
backcross (type="BC"), advanced intercross population (type="AI"), and
recombinant inbred population (type="RI").}

\item{ng}{integer. The generation number of the population type. For
example, the BC1 population is type="BC" with ng=1; the AI F3
population is type="AI" with ng=3.}

\item{cM}{logical. Specify the unit of marker position. cM=TRUE for
centimorgan. Or cM=FALSE for morgan.}

\item{E.vector0}{vector. The initial value for QTL effects. The
number of elements corresponds to the column dimension of the
design matrix. If E.vector0=NULL, the initial value will be 0
for all effects.}

\item{X}{matrix. The design matrix of the fixed factors except for
QTL effects. It is an n*k matrix, where n is the number of
individuals, and k is the number of fixed factors. If X=NULL,
the matrix will be an n*1 matrix that all elements are 1.}

\item{beta0}{vector. The initial value for effects of the fixed
factors. The number of elements corresponds to the column dimension
of the fixed factor design matrix.  If beta0=NULL, the initial
value will be the average of y.}

\item{variance0}{numeric. The initial value for variance. If
variance0=NULL, the initial value will be the variance of
phenotype values.}

\item{crit}{numeric. The convergence criterion of EM algorithm.
The E and M steps will be iterated until a convergence criterion
is satisfied. It must be between 0 and 1.}

\item{stop}{numeric. The stopping criterion of EM algorithm.
The E and M steps will be stop when the iteration number reaches the
stopped criterion, and it will treat the algorithm as failing to converge.}

\item{conv}{logical. If being False, it will ignore the inability to
converge, and output the last result in the process of EM algorithm
before the stopping criterion.}

\item{var.pos}{logical. The variance of the position of QTLs will be
considered in asymptotic variance-covariance matrix or not.}

\item{console}{logical. To decide whether the process of the algorithm
will be shown in the R console or not.}
}
\value{
\item{E.vector}{The QTL effects are calculated by the EM algorithm.}
\item{beta}{The effects of the fixed factors are calculated by the EM
algorithm.}
\item{variance}{The error variance is calculated by the EM algorithm.}
\item{PI.matrix}{The posterior probabilities matrix after the
process of the EM algorithm.}
\item{log.likelihood}{The log-likelihood value of this model.}
\item{LRT}{The LRT statistic of this model.}
\item{R2}{The coefficient of determination of this model. This
can be used as an estimate of heritability.}
\item{y.hat}{The fitted values of trait values are calculated by
the estimated values from the EM algorithm.}
\item{iteration.number}{The iteration number of the EM algorithm.}
\item{avc.matrix}{The asymptotic variance-covariance matrix which contains
position of QTLs, QTL effects, variance, and fix effects.}
\item{EMvar}{The asymptotic approximate variances which contains position
of QTLs, QTL effects, variance, and fix effects. The parameters whose
approximate variance cannot be calculated will be shown as 0.}
}
\description{
Expectation-maximization algorithm for QTL multiple interval mapping.
This function can also obtain the asymptotic variance-covariance matrix
of the result from the EM algorithm and the approximate solution of
variances of parameters.
}
\examples{
# load the example data
load(system.file("extdata", "exampledata.RDATA", package = "QTLEMM"))

# run and result
D.matrix <- D.make(3, type = "RI", aa = c(1, 3, 2, 3), dd = c(1, 2, 1, 3), ad = c(1, 2, 2, 3))
result <- EM.MIMv(QTL, marker, geno, D.matrix, cp.matrix = NULL, y)
result$EMvar
}
\references{
KAO, C.-H. and Z.-B. ZENG 1997 General formulas for obtaining the maximum
likelihood estimates and the asymptotic variance-covariance matrix in QTL
mapping when using the EM algorithm. Biometrics 53, 653-665.

KAO, C.-H., Z.-B. ZENG and R. D. TEASDALE 1999 Multiple interval mapping
for Quantitative Trait Loci. Genetics 152: 1203-1216.
}
\seealso{
\code{\link[QTLEMM]{D.make}}
\code{\link[QTLEMM]{Q.make}}
\code{\link[QTLEMM]{EM.MIM}}
}
