% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IGM.R
\name{igm.get.pvalues}
\alias{igm.get.pvalues}
\title{The permutation-based empirical NULL distribution of P-values is generated through label switching and permutation of the true case/control assignment. To achieve this, for a given matrix it randomly permutes the case and control labels of the original configuration and then recomputes the two-tail Fisher's Exact test for all genes. This is repeated n.permutation (e.g., 1000) times. For each of the n.permutations the p-values are ordered and then the mean of each rank-ordered estimate is taken across the n.permutations, i.e., the average 1st order statistic, the average 2nd order statistic, etc. These then represent the empirical estimates of the expected ordered p-values (expected -log10(p-values)). This empirical-based expected p-value distribution no longer depends on an assumption that the p-values are uniformly distributed under the null.}
\usage{
igm.get.pvalues(matrix, is.case, n.permutations = 1000)
}
\arguments{
\item{matrix}{The input genotype matrix, with rows for genes and columns for samples.}

\item{is.case}{The case(1)/control(0) indicator.}

\item{n.permutations}{The number of label permutations requested. Recommended number is 1,000.}
}
\value{
Returns a list containing the observed P-values based on the correct case/control assignment (observed) and the permuted P-Values reflecting the appropriate NULL distribution for the given case/control configuration (perm).
}
\description{
The permutation-based empirical NULL distribution of P-values is generated through label switching and permutation of the true case/control assignment. To achieve this, for a given matrix it randomly permutes the case and control labels of the original configuration and then recomputes the two-tail Fisher's Exact test for all genes. This is repeated n.permutation (e.g., 1000) times. For each of the n.permutations the p-values are ordered and then the mean of each rank-ordered estimate is taken across the n.permutations, i.e., the average 1st order statistic, the average 2nd order statistic, etc. These then represent the empirical estimates of the expected ordered p-values (expected -log10(p-values)). This empirical-based expected p-value distribution no longer depends on an assumption that the p-values are uniformly distributed under the null.
}
\examples{
#Ps  <- igm.get.pvalues(matrix, is.case)

}
\author{
Slave Petrovski and Quanli Wang
}

