% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/TSDensity.R
\name{TSDensity}
\alias{TSDensity}
\title{Density plot from simulation of two-dimensional stochastic differential equations}
\usage{
TSDensity(mat, dim = 1, xlim = "NULL", ylim = "NULL",
  contour.levels = 15, col2d = c("blue", "yellow", "orange", "red"),
  contour.lwd = 0.5, contour.lines = TRUE, ...)
}
\arguments{
\item{mat}{a matrix output from \code{\link{TSTraj}}.}

\item{dim}{dimensions of the plot; \code{dim=1} plots simple density histogram or \code{dim=2} plots the density in state space (i.e., \code{X} and \code{Y} respectively on the abscissa and ordinate axes).}

\item{xlim}{numeric vectors of length 2, giving the x coordinate range. Default \code{= 'NULL'} automatically sizes plot window.}

\item{ylim}{numeric vectors of length 2, giving the y coordinate range. Default \code{= 'NULL'} automatically sizes plot window.}

\item{contour.levels}{the number of contour levels for the two-dimensional plots (i.e., when \code{dim=2}).}

\item{col2d}{vector of colors to be used in the plot.}

\item{contour.lwd}{line width of contour lines if \code{contour.lines=TRUE}.}

\item{contour.lines}{if TRUE, then black countour lines added to the graph.}

\item{...}{passes arguments to \code{\link{kde2d}} and \code{\link{plot}}.}
}
\description{
This function allows you to create density plots for the simulation of two-dimensional stochastic differential equations in \code{\link{TSTraj}}
}
\examples{
# First, the parameter values, as found in \\code{\\link{TSTraj}}
	model.state <- c(x = 3, y = 3)
	model.sigma <- 0.2
	model.deltat <- 0.005
	model.time <- 100

# Second, write out the deterministic skeleton of the equations to be simulated,
# as found in \\code{\\link{TSTraj}}
	equationx <- "1.54*x*(1.0-(x/10.14)) - (y*x*x)/(1.0 + x*x)"

# Third, run it, as found in \\code{\\link{TSTraj}}
}
\keyword{plot}
\keyword{simulations}
\keyword{stochastic}

