% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QBAD.R
\name{momentQBAD}
\alias{momentQBAD}
\alias{mu_k}
\alias{gamma_k}
\alias{meanQBAD}
\alias{varQBAD}
\alias{skewQBAD}
\alias{kurtQBAD}
\title{Moment estimation for the quantile-based asymmetric family of distributions.}
\usage{
mu_k(f, k)

gamma_k(f, k)

meanQBAD(mu, phi, alpha, mu_1)

varQBAD(mu, phi, alpha, mu_1, mu_2)

skewQBAD(alpha, mu_1, mu_2, mu_3)

kurtQBAD(alpha, mu_1, mu_2, mu_3, mu_4)

momentQBAD(phi, alpha, f, r)
}
\arguments{
\item{f}{This is the reference density function \eqn{f} which is a standard version of a unimodal and symmetric around 0 density.}

\item{k}{This is an integer value (\eqn{k=1,2,3,\ldots}) for calculating \eqn{\mu_k=\int_{0}^{\infty} 2s^k f(s) ds} and \eqn{\gamma_k=\int_{0}^{\infty}s^{k-1}\frac{[f'(s)]^2}{f(s)}ds}.}

\item{mu}{This is the location parameter \eqn{\mu}.}

\item{phi}{This is the scale parameter  \eqn{\phi}.}

\item{alpha}{This is the index parameter  \eqn{\alpha}.}

\item{mu_1}{This is the quantity \eqn{\int_{0}^{\infty} 2 s f(s) ds}.}

\item{mu_2}{This is the quantity \eqn{\int_{0}^{\infty} 2 s^2 f(s) ds}.}

\item{mu_3}{This is the quantity \eqn{\int_{0}^{\infty} 2 s^3 f(s) ds}.}

\item{mu_4}{This is the quantity \eqn{\int_{0}^{\infty} 2 s^4 f(s) ds}.}

\item{r}{This is a value which is used to calculate the \eqn{r}th moment about \eqn{\mu}.}
}
\value{
\code{\link{mu_k}} provides the quantity \eqn{\int_{0}^{\infty} 2s^k f(s) ds}, \code{\link{gamma_k}} provides the quantity \eqn{\int_{0}^{\infty}s^{k-1}\frac{[f'(s)]^2}{f(s)}ds},  \code{\link{meanQBAD}} provides the mean, \code{\link{varQBAD}} provides the variance, \code{\link{skewQBAD}} provides the skewness, \code{\link{kurtQBAD}} provides the kurtosis, and  \code{\link{momentQBAD}} provides the \eqn{r}th moment about the location parameter \eqn{\mu} of the asymmetric family of distributions.
}
\description{
Mean, variance, skewness, kurtosis and moments about the location parameter (i.e., \eqn{\alpha}th quantile) of the quantile-based asymmetric family of densities defined in Gijbels et al. (2019a) useful for quantile regression with location parameter equal to \eqn{\mu}, scale parameter \eqn{\phi} and index parameter \eqn{\alpha}.
}
\examples{
# Example 1: Let F be a standard normal cumulative distribution function then
f_N<-function(s){dnorm(s, mean = 0,sd = 1)} # density function of N(0,1)
mu_k(f=f_N,k=1)
gamma_k(f=f_N,k=1)
mu.1_N=sqrt(2/pi)
mu.2_N=1
mu.3_N=2*sqrt(2/pi)
mu.4_N=4
meanQBAD(mu=0,phi=1,alpha=0.5,mu_1=mu.1_N)
varQBAD(mu=0,phi=1,alpha=0.5,mu_1=mu.1_N,mu_2=mu.2_N)
skewQBAD(alpha=0.5,mu_1=mu.1_N,mu_2=mu.2_N,mu_3=mu.3_N)
kurtQBAD(alpha=0.5,mu_1=mu.1_N,mu_2=mu.2_N,mu_3=mu.3_N,mu_4=mu.4_N)
momentQBAD(phi=1,alpha=0.5,f=f_N,r=1)


# Example 2: Let F be a standard Laplace cumulative distribution function then
f_La<-function(s){0.5*exp(-abs(s))} # density function of Laplace(0,1)
mu_k(f=f_La,k=1)
gamma_k(f=f_La,k=1)
mu.1_La=1
mu.2_La=2
mu.3_La=6
mu.4_La=24
meanQBAD(mu=0,phi=1,alpha=0.5,mu_1=mu.1_La)
varQBAD(mu=0,phi=1,alpha=0.5,mu_1=mu.1_La,mu_2=mu.2_La)
skewQBAD(alpha=0.5,mu_1=mu.1_La,mu_2=mu.2_La,mu_3=mu.3_La)
kurtQBAD(alpha=0.5,mu_1=mu.1_La,mu_2=mu.2_La,mu_3=mu.3_La,mu_4=mu.4_La)
momentQBAD(phi=1,alpha=0.5,f=f_La,r=1)
}
\references{
{
 Gijbels, I., Karim, R. and Verhasselt, A. (2019a). On quantile-based asymmetric family of distributions: properties and inference. \emph{International Statistical Review}, \url{https://doi.org/10.1111/insr.12324}.
}
}
