% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method-WAAPWLS.R
\name{method.WAAPWLS}
\alias{method.WAAPWLS}
\title{WAAPWLS (Weighted Average of Adequately Powered Studies) Method}
\usage{
\method{method}{WAAPWLS}(method_name, data, settings = NULL)
}
\arguments{
\item{method_name}{Method name (automatically passed)}

\item{data}{Data frame with yi (effect sizes) and sei (standard errors)}

\item{settings}{List of method settings (no settings version are implemented)}
}
\value{
Data frame with WAAPWLS results
}
\description{
Implements the WAAP-WLS method for meta-analysis, which combines WLS and WAAP approaches.
First fits a WLS model to all studies, then identifies high-powered studies based on
the criterion that the WLS estimate divided by 2.8 is greater than or equal to the
standard error. If at least 2 high-powered studies are found, uses WAAP (weighted
average of adequate power studies only), otherwise uses the original WLS estimate.
See \insertCite{stanley2017finding;textual}{PublicationBiasBenchmark} for details.
}
\examples{
# Generate some example data
data <- data.frame(
  yi = c(0.2, 0.3, 0.1, 0.4, 0.25),
  sei = c(0.1, 0.15, 0.08, 0.12, 0.09)
)

# Apply WAAPWLS method
result <- run_method("WAAPWLS", data)
print(result)

}
\references{
\insertAllCited{}
}
