% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_substances.R
\name{get_substances}
\alias{get_substances}
\title{Retrieve Substances from PubChem}
\usage{
get_substances(identifier, namespace = "sid", ...)
}
\arguments{
\item{identifier}{A character or numeric vector specifying the identifiers for the request.}

\item{namespace}{A character string specifying the namespace for the request. Default is 'sid'.}

\item{...}{Additional parameters passed to \code{\link{get_json}}.}
}
\value{
A named list where each element corresponds to a substance retrieved from PubChem.
        The names of the list elements are based on the provided identifiers.
        If no substance is found for a given identifier, the corresponding list element will contain the string "No substance".
}
\description{
This function sends a request to PubChem to retrieve substance data based on the specified parameters.
It returns a list of substances corresponding to the provided identifiers.
}
\examples{
get_substances(
  identifier = "aspirin",
  namespace = "name"
)
}
