% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01-basic.R
\name{as_embed}
\alias{as_embed}
\alias{as_wordvec}
\alias{[.embed}
\alias{pattern}
\title{Word vectors data class: \code{wordvec} and \code{embed}.}
\usage{
as_embed(x, normalize = FALSE)

as_wordvec(x, normalize = FALSE)

\method{[}{embed}(x, i, j)

pattern(pattern)
}
\arguments{
\item{x}{Object to be reshaped. See examples.}

\item{normalize}{Normalize all word vectors to unit length?
Defaults to \code{FALSE}. See \code{\link{normalize}}.}

\item{i, j}{Row (\code{i}) and column (\code{j}) filter to be used in \code{embed[i, j]}.}

\item{pattern}{Regular expression to be used in \code{embed[pattern("...")]}.}
}
\value{
A \code{wordvec} (data.table) or \code{embed} (matrix).
}
\description{
\code{PsychWordVec} uses two types of word vectors data:
\code{wordvec} (data.table, with two variables \code{word} and \code{vec})
and \code{embed} (matrix, with dimensions as columns and words as row names).
Note that matrix operation makes \code{embed} much faster than \code{wordvec}.
Users are suggested to reshape data to \code{embed} before using the other functions.
}
\section{Functions}{
\itemize{
\item \code{as_embed()}: From \code{wordvec} (data.table) to \code{embed} (matrix).

\item \code{as_wordvec()}: From \code{embed} (matrix) to \code{wordvec} (data.table).

}}
\section{Download}{

Download pre-trained word vectors data (\code{.RData}):
\url{https://psychbruce.github.io/WordVector_RData.pdf}
}

\examples{
dt = head(demodata, 10)
str(dt)

embed = as_embed(dt, normalize=TRUE)
embed
str(embed)

wordvec = as_wordvec(embed, normalize=TRUE)
wordvec
str(wordvec)

df = data.frame(token=LETTERS, D1=1:26/10000, D2=26:1/10000)
as_embed(df)
as_wordvec(df)

dd = rbind(dt[1:5], dt[1:5])
dd  # duplicate words
unique(dd)

dm = as_embed(dd)
dm  # duplicate words
unique(dm)

\donttest{# more examples for extracting a subset using `x[i, j]`
# (3x faster than `wordvec`)
embed = as_embed(demodata)
embed[1]
embed[1:5]
embed["for"]
embed[pattern("^for.{0,2}$")]
embed[cc("for, in, on, xxx")]
embed[cc("for, in, on, xxx"), 5:10]
embed[1:5, 5:10]
embed[, 5:10]
embed[3, 4]
embed["that", 4]
}
}
\seealso{
\code{\link{load_wordvec}} / \code{\link{load_embed}}

\code{\link{normalize}}

\code{\link{data_transform}}

\code{\link{data_wordvec_subset}}
}
