% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/09playing_routines.r
\docType{methods}
\name{modToWave}
\alias{modToWave}
\alias{modToWave,PTModule-method}
\title{Convert a PTModule object into an audio Wave object}
\usage{
\S4method{modToWave}{PTModule}(mod, video = c("PAL", "NTSC"),
  target.rate = 44100, target.bit = 16, stereo.separation = 1,
  low.pass.filter = TRUE, tracks = 1:4, ...)
}
\arguments{
\item{mod}{An object of class \code{\link{PTModule}}}

\item{video}{The video mode of a Commodore Amiga affects timing routines and
the playback sample rate. This mode can be specified with this argument and
is represented by a \code{character} string that can have either the value
`\href{https://en.wikipedia.org/wiki/PAL}{PAL}'
or `\href{https://en.wikipedia.org/wiki/NTSC}{NTSC}'. PAL is used by default.}

\item{target.rate}{A positive \code{integer} sample rate for the target \code{Wave}.
Should be at least 2000.
Default value is 44100 Hz, which is conform CD quality. 22050 Hz will also
produce a decent sound quality and saves you some working memory.}

\item{target.bit}{Number of bits for the target \code{Wave}. Should be a \code{numeric}
value of either 8, 16, 24 or 32. Default is 16, which is conform CD quality
(the quality doesn't really improve at higher bit values, as the original
samples are of 8 bit quality).}

\item{stereo.separation}{A \code{numeric} value between 0 and 1.
When set to 1 (default), stereo channels (Amiga channels 1 and 4 on left,
and channels 2 and 3 on right) are completely separated. When set to
less than 1, stereo channels are mixed, where the number gives the
fraction of separation of the channels. When set to 0, both channels
are completely mixed and a mono \code{Wave} is returned.}

\item{low.pass.filter}{A \code{logical} value indicating whether low pass
filters should be applied when generating wave data. The Commodore Amiga
had hardware audio filters. One (low pass 6 db/Oct tuned at
4.9 kHz) that filters all audio and one (low pass 12 db/Oct tuned at
approximately 3.3 kHz) that can be turned on and off at will with effect
command E00/E01 (see also \link{ProTrackR} documentation,
section on effect commands). These filters are only applied when the
\code{low.pass.filter} argument is set to \code{TRUE} and the
\code{target.rate} is set to values > 4.9 kHz. If you don't want to simulate
this typical Amiga sound, turn the filters off to save processing time.}

\item{tracks}{Either \code{logical} or \code{numeric} values indicating
which of the 4 \code{\link{PTTrack}}s are to be converted. By default
all 4 tracks are selected.}

\item{...}{Additional arguments that are passed to \code{\link{playingtable}}.}
}
\value{
A \code{\link[tuneR]{Wave}} object, generated from the
\code{mod} object is returned.
}
\description{
Converts a \code{\link{PTModule}} object into a \code{\link[tuneR]{Wave}}
object, which can be played, further analysed, modified and saved.
}
\details{
Before the \code{\link{PTModule}} object can be converted into a
\code{\link[tuneR]{Wave}} object, the rows of the
\code{\link{PTPattern}} objects in the module need to be put
in the right order. This method does that by calling
\code{\link{playingtable}}.

Once the rows of the pattern tables are in the right order, all selected
\code{\link{PTTrack}} objects of the module are looped by this function
and the routines described below are applied to each track.

On the Commodore Amiga the chip responsible for audio output (Paula),
the audio playback of samples can be controlled by the user in two ways:
the playback rate of the sample can be changed by specifying `period'
values (see e.g. \code{\link{periodToSampleRate}}) and specifying a
volume which is linearly scaled between 0 (silent) and 64 (maximum).

So, for each track, the correct period and volume values are determined
based on the note, effect command and sample information in the module.

Then, the \code{\link{PTSample}} objects are resampled, using the
period values and volume values as determined in the previous step.

Next audio filters are applied to mimic original Commodore Amiga
sound. Finaly, the wave data for each separate track is mixed to
one (mono) or two (stereo) of the output channels.

Converting ProTracker modules into wave objects can be time consuming.
The time required to convert an object obviously depends on your
machine's capacities and the length of the module but also the
complexity of the module. To speed up the conversion you could
reduce the target sample rate or turn off the low pass filter.
On modern machines, the time required for conversion should generally
be less than the playback time of the module.

You can save the resulting \code{\link[tuneR]{Wave}} object by calling
\code{\link[tuneR]{writeWave}}.
}
\note{
As audio can be mixed with this package at frequencies much greater than the
Commodore Amiga's audio output rate, some aliasing of the sound could occur.
This results in high frequency audio, that would not be produced on an Amiga.
The current version of this package does not filter out these artefacts.
This should not be a problem if you're not concerned with producing an
accurate Amiga timbre.
}
\examples{
\dontrun{
data(mod.intro)
wav <- modToWave(mod.intro)
}
}
\author{
Pepijn de Vries
}
\seealso{
Other module.operations: \code{\link{PTModule-class}},
  \code{\link{appendPattern}}, \code{\link{clearSamples}},
  \code{\link{clearSong}}, \code{\link{deletePattern}},
  \code{\link{moduleSize}}, \code{\link{patternLength}},
  \code{\link{patternOrderLength}},
  \code{\link{patternOrder}}, \code{\link{playMod}},
  \code{\link{playingtable}}, \code{\link{read.module}},
  \code{\link{trackerFlag}}, \code{\link{write.module}}
}

