% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_a_bill.R
\name{get_a_bill}
\alias{get_a_bill}
\title{Get a Specific Bill}
\usage{
get_a_bill(congress, bill_id, page = 1, myAPI_Key)
}
\arguments{
\item{congress}{105-116}

\item{bill_id}{a bill slug, for example hr4881 - these can be found in the recent bill response.}

\item{page}{Results come in batches of 20. The page parameter specifies which one to retrieve.}

\item{myAPI_Key}{API key from Propublica To use the congress API, you must sign up for an API key.}
}
\value{
List with the result of the query
}
\description{
Use this request type to get details on bills that may be considered by the House or Senate in the near future,
based on scheduled published or announced by congressional leadership.
}
\details{
The responses include a legislative_day attribute which is the earliest the bills could be considered,
and a range attribute that indicates whether the bill information comes from a weekly schedule or a daily one.
Combine the two for the best sense of when a bill might come up for consideration. For Senate bills,
the response includes a context attribute reproducing the sentence that includes mention of the bill.
These responses omit bills that have not yet been assigned a bill number or introduced, and additional bills
may be considered at any time.
}
\examples{
\donttest{
get_a_bill(115, 'hr21')
}
}
