% Generated by roxygen2 (4.0.2): do not edit by hand
\name{summary.PrevMap}
\alias{summary.PrevMap}
\title{Summarizing likelihood-based model fits}
\usage{
\method{summary}{PrevMap}(object, log.cov.pars = TRUE, ...)
}
\arguments{
\item{object}{an object of class "PrevMap" obatained as result of a call to \code{\link{binomial.logistic.MCML}} or \code{\link{linear.model.MLE}}.}

\item{log.cov.pars}{logical; if \code{log.cov.pars=TRUE} the estimates of the covariance parameters are given on the log-scale. Note that standard errors are also adjusted accordingly. Default is \code{log.cov.pars=TRUE}.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
A list with the following components

\code{linear}: logical value; \code{linear=TRUE} if a linear model was fitted and \code{linear=FALSE} otherwise.

\code{ck}: logical value; \code{ck=TRUE} if a low-rank approximation was used and \code{ck=FALSE} otherwise.

\code{coefficients}: matrix of the estimates, standard errors and p-values of the estimates of the regression coefficients.

\code{cov.pars}: matrix of the estimates and standard errors of the covariance parameters.

\code{log.lik}: value of likelihood function at the maximum likelihood estimates.

\code{kappa}: fixed value of the shape paramter of the Matern covariance function.

\code{fixed.rel.nugget}: fixed value for the relative variance of the nugget effect.

\code{call}: matched call.
}
\description{
\code{summary} method for the class "PrevMap" that computes the standard errors and p-values of likelihood-based model fits.
}
\author{
Emanuele Giorgi \email{e.giorgi@lancaster.ac.uk}

Peter J. Diggle \email{p.diggle@lancaster.ac.uk}
}

