% Generated by roxygen2 (4.0.2): do not edit by hand
\name{spatial.pred.linear.MLE}
\alias{spatial.pred.linear.MLE}
\title{Spatial predictions for the geostatistical Linear Gaussian model using plug-in of ML estimates}
\usage{
spatial.pred.linear.MLE(object, grid.pred, predictors = NULL,
  type = "marginal", scale.predictions = c("logit", "prevalence", "odds"),
  quantiles = c(0.025, 0.975), n.sim.prev = 1000, standard.errors = FALSE,
  thresholds = NULL, scale.thresholds = NULL, messages = TRUE)
}
\arguments{
\item{object}{an object of class "PrevMap" obtained as result of a call to \code{\link{linear.model.MLE}}.}

\item{grid.pred}{a matrix of prediction locations.}

\item{predictors}{a data frame of the values of the explanatory variables at each of the locations in \code{grid.pred}; each column correspond to a variable and each row to a location. \bold{Warning:} the names of the columns in the data frame must match those in the data used to fit the model. Default is \code{predictors=NULL} for models with only an intercept.}

\item{type}{a character indicating the type of spatial predictions: \code{type="marginal"} for marginal predictions or \code{type="joint"} for joint predictions. Default is \code{type="marginal"}. In the case of a low-rank approximation only marginal predictions are available.}

\item{scale.predictions}{a character vector of maximum length 3, indicating the required scale on which spatial prediction is carried out: "logit", "prevalence" and "odds". Default is \code{scale.predictions=c("logit","prevalence","odds")}.}

\item{quantiles}{a vector of quantiles used to summarise the spatial predictions.}

\item{n.sim.prev}{number of simulation for predictions of prevalence. Default is \code{n.sim.prev=1000}.}

\item{standard.errors}{logical; if \code{standard.errors=TRUE}, then standard errors for each \code{scale.predictions} are returned. Default is \code{standard.errors=FALSE}.}

\item{thresholds}{a vector of exceedance thresholds; default is \code{thresholds=NULL}.}

\item{scale.thresholds}{a character value indicating the scale on which exceedance thresholds are provided; \code{"logit"}, \code{"prevalence"} or \code{"odds"}. Default is \code{scale.thresholds=NULL}.}

\item{messages}{logical; if \code{messages=TRUE} then status messages are printed on the screen (or output device) while the function is running. Default is \code{messages=TRUE}.}
}
\value{
A "pred.PrevMap" object list with the following components: \code{logit}; \code{prevalence}; \code{odds}; \code{exceedance.prob}, corresponding to a matrix of the exceedance probabilities where each column corresponds to a specified value in \code{thresholds}; \code{grid.pred} prediction locations; \code{samples}, corresponding to the predictive samples of the linear predictor (only if \code{any(scale.predictions=="prevalence")}).
Each of the three components \code{logit}, \code{prevalence} and  \code{odds} is also a list with the following components:

\code{predictions}: a vector of the predictive mean for the associated quantity (logit, odds or prevalence).

\code{standard.errors}: a vector of prediction standard errors (if \code{standard.errors=TRUE}).

\code{quantiles}: a matrix of quantiles of the resulting predictions with each column corresponding to a quantile specified through the argument \code{quantiles}.
}
\description{
This function performs spatial prediction for fixed parameters at the maximum likelihood estimates of a linear geostatistical model.
}
\author{
Emanuele Giorgi \email{e.giorgi@lancaster.ac.uk}

Peter J. Diggle \email{p.diggle@lancaster.ac.uk}
}

