% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ml.R
\name{make_labels}
\alias{make_labels}
\title{Make future-return labels aligned to the decision date}
\usage{
make_labels(prices, horizon = 4L, type = c("log", "simple", "sign"))
}
\arguments{
\item{prices}{Wide price panel (\code{Date} + symbols).}

\item{horizon}{Integer \code{>= 1}, number of forward steps for the label.}

\item{type}{Character, one of \code{"log"}, \code{"simple"}, \code{"sign"}.}
}
\value{
A \code{data.table} with \code{Date} + symbols containing the labels.
}
\description{
Compute forward returns over a fixed horizon and align them to the decision date.
}
\details{
For each date \eqn{t}, the label is computed from prices at \eqn{t} and \eqn{t + h}.
\itemize{
\item \code{type = "simple"}: \eqn{p_{t+h}/p_t - 1}
\item \code{type = "log"}: \eqn{\log(p_{t+h}) - \log(p_t)}
\item \code{type = "sign"}: \code{sign(simple return)}
}
Trailing dates that do not have \code{horizon} steps ahead are set to \code{NA}.
}
