/*
 * Decompiled with CFR 0.152.
 */
package com.portfolioeffect.quant.client.util;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.portfolioeffect.quant.client.model.ComputeErrorException;
import com.portfolioeffect.quant.client.portfolio.Portfolio;
import com.portfolioeffect.quant.client.portfolio.Position;
import com.portfolioeffect.quant.client.result.LazyMetric;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LazyMetricBuilder {
    private HashMap<String, String> map;
    private HashMap<String, List<String>> mapList;
    private int windowLength;
    private int rollingWindowLength;
    private int forecastStep;

    public LazyMetricBuilder() {
        this.map = new HashMap();
        this.mapList = new HashMap();
    }

    public LazyMetricBuilder(LazyMetricBuilder builder) {
        this.map = new HashMap<String, String>(builder.map);
        this.mapList = new HashMap();
        for (Map.Entry<String, List<String>> e : builder.mapList.entrySet()) {
            this.mapList.put(e.getKey(), new ArrayList(e.getValue()));
        }
        this.windowLength = builder.windowLength;
        this.rollingWindowLength = builder.rollingWindowLength;
        this.forecastStep = builder.forecastStep;
    }

    public LazyMetricBuilder(String jsonStr) {
        this();
        Gson gson = new Gson();
        Type type = new TypeToken<HashMap<String, String>>(){}.getType();
        HashMap map = (HashMap)gson.fromJson(jsonStr, type);
        for (Map.Entry e : map.entrySet()) {
            this.setParam((String)e.getKey(), (String)e.getValue());
        }
    }

    public LazyMetricBuilder(Map<String, String> map) {
        this();
        for (Map.Entry<String, String> e : map.entrySet()) {
            this.setParam(e.getKey(), e.getValue());
        }
    }

    public LazyMetric build(Portfolio portfolio) {
        this.makeBeforeBuildPortfolio(portfolio);
        LazyMetric lazyMetric = portfolio.getLazyMetric(this);
        this.makeAfterBuildPortfolio(portfolio, lazyMetric);
        return lazyMetric;
    }

    private void makeAfterBuildPortfolio(Portfolio portfolio, LazyMetric lazyMetric) {
        if (!this.map.get("metric").contains("TIME_SHIFT") && this.map.containsKey("timeShift") && this.map.get("timeShift").equals("true") && this.map.containsKey("forecastStep")) {
            LazyMetricBuilder timeShiftBuilder = new LazyMetricBuilder();
            timeShiftBuilder.setParam("metric", "TIME_SHIFT");
            timeShiftBuilder.setParam("timeShift", this.map.get("forecastStep"));
            lazyMetric.setTimeShift(timeShiftBuilder.build(portfolio));
        }
    }

    private void makeBeforeBuildPortfolio(Portfolio portfolio) {
        String type = this.map.get("metric");
        if (!(type.contains("PORTFOLIO_") || type.contains("POSITION_") || type.contains("INDEX_"))) {
            this.map.put("metric", "PORTFOLIO_" + type);
        }
        if (type.contains("POSITION_") || type.contains("INDEX_")) {
            this.map.put("metric", "PORTFOLIO_" + type.split("_", 2)[1]);
        }
        if (!this.map.containsKey("windowLength")) {
            this.setParam("windowLength", portfolio.getWindowLength());
        }
    }

    public LazyMetric build(Portfolio portfolio, boolean isLeftOffCompute) {
        boolean isMultibatch = portfolio.isMultiBatch();
        if (isLeftOffCompute) {
            portfolio.clearCache();
            portfolio.setMultiBatchEnabled(true);
        }
        this.makeBeforeBuildPortfolio(portfolio);
        LazyMetric lazyMetric = portfolio.getLazyMetric(this);
        this.makeAfterBuildPortfolio(portfolio, lazyMetric);
        if (isLeftOffCompute) {
            portfolio.setMultiBatchEnabled(isMultibatch);
        }
        return lazyMetric;
    }

    public String buildStrRequest(Portfolio portfolio) {
        this.makeBeforeBuildPortfolio(portfolio);
        return portfolio.getStrRequest(this);
    }

    public LazyMetric build(Position position, boolean isLeftOffCompute) {
        boolean isMultibatch = position.getPortfolio().isMultiBatch();
        if (isLeftOffCompute) {
            position.getPortfolio().clearCache();
            position.getPortfolio().setMultiBatchEnabled(true);
        }
        this.makeBeforeBuildPosition(position);
        LazyMetric lazyMetric = position.getPortfolio().getLazyMetric(this);
        this.makeAfterBuildPosition(position, lazyMetric);
        if (isLeftOffCompute) {
            position.getPortfolio().setMultiBatchEnabled(isMultibatch);
        }
        return lazyMetric;
    }

    private void makeAfterBuildPosition(Position position, LazyMetric lazyMetric) {
        if (!this.map.get("metric").contains("TIME_SHIFT") && this.map.containsKey("timeShift") && this.map.get("timeShift").equals("true") && this.map.containsKey("forecastStep")) {
            LazyMetricBuilder timeShiftBuilder = new LazyMetricBuilder();
            timeShiftBuilder.setParam("metric", "TIME_SHIFT");
            timeShiftBuilder.setParam("timeShift", this.map.get("forecastStep"));
            lazyMetric.setTimeShift(timeShiftBuilder.build(position.getPortfolio()));
        }
    }

    private void makeBeforeBuildPosition(Position position) {
        String type = this.map.get("metric");
        if (!(type.contains("PORTFOLIO_") || type.contains("POSITION_") || type.contains("INDEX_"))) {
            this.map.put("metric", "POSITION_" + type);
        }
        if (type.contains("PORTFOLIO_") || type.contains("INDEX_")) {
            this.map.put("metric", "POSITION_" + type.split("_", 2)[1]);
        }
        this.map.put("position", position.getName());
        if (!this.map.containsKey("windowLength")) {
            this.setParam("windowLength", position.getPortfolio().getWindowLength());
        }
    }

    public LazyMetric build(Position position) {
        this.makeBeforeBuildPosition(position);
        LazyMetric lazyMetric = position.getPortfolio().getLazyMetric(this);
        this.makeAfterBuildPosition(position, lazyMetric);
        lazyMetric.setPosition(position);
        return lazyMetric;
    }

    public LazyMetricBuilder removeList(String key) {
        this.mapList.remove(key);
        return this;
    }

    public LazyMetricBuilder removeParam(String key) {
        this.map.remove(key);
        return this;
    }

    public LazyMetric build(Position positionA, Position positionB) {
        String type = this.map.get("metric");
        this.map.put("metric", "POSITION_" + type);
        this.map.put("positionA", positionA.getName());
        this.map.put("positionB", positionB.getName());
        if (!this.map.containsKey("windowLength")) {
            this.setParam("windowLength", positionA.getPortfolio().getWindowLength());
        }
        LazyMetric lazyMetric = positionA.getPortfolio().getLazyMetric(this);
        return lazyMetric;
    }

    public LazyMetricBuilder addToList(String key, String value) {
        if (value.equals("windowLength")) {
            this.windowLength = Math.max(this.windowLength, Portfolio.parseWindowLength(value));
        }
        if (this.mapList.containsKey(key)) {
            this.mapList.get(key).add(value);
        } else {
            this.mapList.put(key, new ArrayList());
            this.mapList.get(key).add(value);
        }
        return this;
    }

    public LazyMetricBuilder addToList(String key, Position value) {
        if (value.equals("windowLength")) {
            this.windowLength = Math.max(this.windowLength, Portfolio.parseWindowLength(value.getName()));
        }
        if (this.mapList.containsKey(key)) {
            this.mapList.get(key).add(value.getName());
        } else {
            this.mapList.put(key, new ArrayList());
            this.mapList.get(key).add(value.getName());
        }
        return this;
    }

    public LazyMetricBuilder addToList(String key, LazyMetric lazyMetric) throws ComputeErrorException {
        if (lazyMetric.getLazyMetricBuilder() == null) {
            throw new ComputeErrorException("LazyMetricBuilder is not set");
        }
        this.addToList(key, lazyMetric.getLazyMetricBuilder());
        return this;
    }

    private LazyMetricBuilder addToList(String key, LazyMetricBuilder lazyMetric) {
        String value = "";
        Gson gson = new Gson();
        value = gson.toJson(lazyMetric.getParamsMap());
        this.addToList(key, value);
        this.windowLength = Math.max(this.windowLength, lazyMetric.windowLength);
        this.rollingWindowLength = Math.max(this.rollingWindowLength, lazyMetric.rollingWindowLength);
        this.forecastStep = Math.max(this.forecastStep, lazyMetric.forecastStep);
        return this;
    }

    public LazyMetricBuilder setParam(String key, String value) {
        if (value.length() == 0) {
            return this.removeParam(key);
        }
        if (key.equals("windowLength")) {
            this.windowLength = Portfolio.parseWindowLength(value);
        }
        if (key.equals("rollingWindow")) {
            this.rollingWindowLength = Portfolio.parseWindowLength(value);
        }
        if (key.equals("forecastStep")) {
            this.forecastStep = Portfolio.parseWindowLength(value);
        }
        if (!this.map.containsKey("metric") && key.equals("metric")) {
            String metricTpe = value.replaceFirst("POSITION_", "");
            metricTpe = metricTpe.replaceFirst("PORTFOLIO_", "");
            this.map.put("metricType", metricTpe);
        }
        this.map.put(key, value);
        return this;
    }

    public LazyMetricBuilder setParam(String jsonStr) {
        Gson gson = new Gson();
        Type type = new TypeToken<HashMap<String, String>>(){}.getType();
        HashMap map = (HashMap)gson.fromJson(jsonStr, type);
        for (Map.Entry e : map.entrySet()) {
            this.setParam((String)e.getKey(), (String)e.getValue());
        }
        return this;
    }

    public LazyMetricBuilder setParam(HashMap<String, String> mapParam) {
        for (Map.Entry<String, String> e : mapParam.entrySet()) {
            this.setParam(e.getKey(), e.getValue());
        }
        return this;
    }

    public LazyMetricBuilder setParam(String key, LazyMetric lazyMetric) throws ComputeErrorException {
        if (lazyMetric.getLazyMetricBuilder() == null) {
            throw new ComputeErrorException("LazyMetricBuilder is not set");
        }
        this.setParam(key, lazyMetric.getLazyMetricBuilder());
        return this;
    }

    private LazyMetricBuilder setParam(String key, LazyMetricBuilder lazyMetric) {
        String value = "";
        Gson gson = new Gson();
        value = gson.toJson(lazyMetric.getParamsMap());
        this.setParam(key, value);
        this.windowLength = Math.max(this.windowLength, lazyMetric.windowLength);
        this.rollingWindowLength = Math.max(this.rollingWindowLength, lazyMetric.rollingWindowLength);
        this.forecastStep = Math.max(this.forecastStep, lazyMetric.forecastStep);
        return this;
    }

    public LazyMetricBuilder reset() {
        this.map.clear();
        this.mapList.clear();
        this.windowLength = 0;
        this.rollingWindowLength = 0;
        this.forecastStep = 0;
        return this;
    }

    private HashMap<String, String> getParamsMap() {
        HashMap<String, String> fullMap = new HashMap<String, String>(this.map);
        Gson gson = new Gson();
        for (String e : this.mapList.keySet()) {
            fullMap.put(e, gson.toJson(this.mapList.get(e)));
        }
        return fullMap;
    }

    public String getJsonString() {
        HashMap<String, String> fullMap = new HashMap<String, String>(this.map);
        Gson gson = new Gson();
        for (String e : this.mapList.keySet()) {
            fullMap.put(e, gson.toJson(this.mapList.get(e)));
        }
        return gson.toJson(fullMap);
    }

    public int getActualWindowLenght() {
        return this.forecastStep + this.windowLength + this.rollingWindowLength;
    }

    public String getParam(String key) {
        return this.map.get(key);
    }

    public boolean contains(String string) {
        return this.map.containsKey(string);
    }
}

