/*
 * Decompiled with CFR 0.152.
 */
package com.portfolioeffect.quant.client.portfolio;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.portfolioeffect.quant.client.ClientConnection;
import com.portfolioeffect.quant.client.portfolio.ArrayCache;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class PortfolioData {
    private boolean isNaNFiltered = true;
    private boolean isNaN2Zero = false;
    private HashMap<String, String> settings;
    private HashMap<String, ArrayCache> symbolQuantityMap = new HashMap();
    private HashMap<String, ArrayCache> symbolQuantityTimeMap;
    private HashMap<String, ArrayCache> symbolPriceMap;
    private HashMap<String, ArrayCache> symbolPriceTimeMap;
    private List<String> symbolNamesList;
    private long dataId;
    private ArrayCache indexPrice;
    private ArrayCache indexTimeMillisec;
    private HashMap<String, Long> priceID;
    private HashMap<String, Long> quantityID;
    private Set<String> userPrice;

    public PortfolioData(PortfolioData data) throws IOException {
        for (String e : data.symbolQuantityMap.keySet()) {
            this.symbolQuantityMap.put(e, new ArrayCache(data.symbolQuantityMap.get(e).getIntArray()));
        }
        this.symbolQuantityTimeMap = new HashMap();
        for (String e : data.symbolQuantityTimeMap.keySet()) {
            this.symbolQuantityTimeMap.put(e, new ArrayCache(data.symbolQuantityTimeMap.get(e).getLongArray()));
        }
        this.symbolPriceMap = new HashMap();
        for (String e : data.symbolPriceMap.keySet()) {
            this.symbolPriceMap.put(e, new ArrayCache(data.symbolPriceMap.get(e).getDoubleArray()));
        }
        this.symbolPriceTimeMap = new HashMap();
        for (String e : data.symbolPriceTimeMap.keySet()) {
            this.symbolPriceTimeMap.put(e, new ArrayCache(data.symbolPriceTimeMap.get(e).getLongArray()));
        }
        this.symbolNamesList = new ArrayList<String>(data.symbolNamesList);
        this.dataId = data.dataId;
        if (data.indexPrice != null) {
            this.indexPrice = new ArrayCache(data.indexPrice.getDoubleArray());
        }
        if (data.indexTimeMillisec != null) {
            this.indexTimeMillisec = new ArrayCache(data.indexTimeMillisec.getLongArray());
        }
        this.priceID = new HashMap<String, Long>(data.priceID);
        this.quantityID = new HashMap<String, Long>(data.quantityID);
        this.userPrice = new HashSet<String>(data.userPrice);
        this.settings = new HashMap<String, String>(data.settings);
        this.settings.put("portfolioId", "" + ClientConnection.getNewId());
    }

    public PortfolioData() {
        this.symbolQuantityTimeMap = new HashMap();
        this.symbolPriceMap = new HashMap();
        this.symbolPriceTimeMap = new HashMap();
        this.symbolNamesList = new ArrayList<String>();
        this.settings = new HashMap();
        this.settings.put("fromTime", "#");
        this.settings.put("toTime", "#");
        this.dataId = 0L;
        this.settings.put("portfolioId", "" + ClientConnection.getNewId());
        this.indexPrice = null;
        this.indexTimeMillisec = null;
        this.priceID = new HashMap();
        this.quantityID = new HashMap();
        this.userPrice = new HashSet<String>();
    }

    public String getIndexSymbol() {
        return this.settings.get("indexSymbol");
    }

    public void setIndexSymbol(String indexSymbol) {
        this.settings.put("indexSymbol", indexSymbol);
    }

    public HashMap<String, ArrayCache> getSymbolQuantityMap() {
        return this.symbolQuantityMap;
    }

    public void setSymbolQuantityMap(HashMap<String, ArrayCache> symbolQuantityMap) {
        this.symbolQuantityMap = symbolQuantityMap;
    }

    public HashMap<String, ArrayCache> getSymbolQuantityTimeMap() {
        return this.symbolQuantityTimeMap;
    }

    public void setSymbolQuantityTimeMap(HashMap<String, ArrayCache> symbolQuantityTimeMap) {
        this.symbolQuantityTimeMap = symbolQuantityTimeMap;
    }

    public HashMap<String, ArrayCache> getSymbolPriceMap() {
        return this.symbolPriceMap;
    }

    public void setSymbolPriceMap(HashMap<String, ArrayCache> symbolPriceMap) {
        this.symbolPriceMap = symbolPriceMap;
    }

    public HashMap<String, ArrayCache> getSymbolPriceTimeMap() {
        return this.symbolPriceTimeMap;
    }

    public void setSymbolPriceTimeMap(HashMap<String, ArrayCache> symbolPriceTimeMap) {
        this.symbolPriceTimeMap = symbolPriceTimeMap;
    }

    public List<String> getSymbolNamesList() {
        return this.symbolNamesList;
    }

    public void setSymbolNamesList(List<String> symbolNamesList) {
        this.symbolNamesList = symbolNamesList;
    }

    public String getFromTime() {
        return this.settings.get("fromTime");
    }

    public void setFromTime(String fromTime) {
        this.settings.put("fromTime", fromTime);
    }

    public String getToTime() {
        return this.settings.get("toTime");
    }

    public void setToTime(String toTime) {
        this.settings.put("toTime", toTime);
    }

    public long getDataId() {
        return this.dataId;
    }

    public void setDataId(int dataId) {
        this.dataId = dataId;
    }

    public long getPortfolioId() {
        return Long.valueOf(this.settings.get("portfolioId"));
    }

    public void setPortfolioId(long portfolioId) {
        this.settings.put("portfolioId", "" + ClientConnection.getNewId());
    }

    public ArrayCache getIndexPrice() {
        return this.indexPrice;
    }

    public void setIndexPrice(ArrayCache indexPrice) {
        this.indexPrice = indexPrice;
    }

    public ArrayCache getIndexTimeMillisec() {
        return this.indexTimeMillisec;
    }

    public void setIndexTimeMillisec(ArrayCache indexTimeMillisec) {
        this.indexTimeMillisec = indexTimeMillisec;
    }

    public HashMap<String, Long> getPriceID() {
        return this.priceID;
    }

    public void setPriceID(HashMap<String, Long> priceID) {
        this.priceID = priceID;
    }

    public HashMap<String, Long> getQuantityID() {
        return this.quantityID;
    }

    public void setQuantityID(HashMap<String, Long> quantityID) {
        this.quantityID = quantityID;
    }

    public long getNextDataId() {
        return this.dataId++;
    }

    public Set<String> getUserPrice() {
        return this.userPrice;
    }

    public void setUserPrice(Set<String> userPrice) {
        this.userPrice = userPrice;
    }

    public HashMap<String, String> getSettings() {
        return this.settings;
    }

    public void setParam(String key, String value) {
        this.settings.put(key, value);
    }

    public String getParam(String key) {
        return this.settings.get(key);
    }

    public void setSettings(HashMap<String, String> settings) {
        this.settings.putAll(settings);
    }

    public void setSettingJSON(String JSONString) {
        Gson gson = new Gson();
        Type mapType = new TypeToken<HashMap<String, String>>(){}.getType();
        HashMap newSettings = (HashMap)gson.fromJson(JSONString, mapType);
        this.settings.putAll(newSettings);
    }

    public String getSettingJSON() {
        Gson gson = new Gson();
        return gson.toJson(this.settings);
    }

    public boolean isNaNFiltered() {
        return this.isNaNFiltered;
    }

    public void setNaNFiltered(boolean isNaNFiltered) {
        this.isNaNFiltered = isNaNFiltered;
    }

    public boolean isNaN2Zero() {
        return this.isNaN2Zero;
    }

    public void setNaN2Zero(boolean isNaN2Zero) {
        this.isNaN2Zero = isNaN2Zero;
    }
}

