/*
 * Decompiled with CFR 0.152.
 */
package org.openfast.template.loader;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.openfast.error.ErrorCode;
import org.openfast.error.ErrorHandler;
import org.openfast.error.FastAlertSeverity;
import org.openfast.error.FastConstants;
import org.openfast.error.FastException;
import org.openfast.template.BasicTemplateRegistry;
import org.openfast.template.MessageTemplate;
import org.openfast.template.TemplateRegistry;
import org.openfast.template.loader.ByteVectorParser;
import org.openfast.template.loader.ComposedDecimalParser;
import org.openfast.template.loader.FieldParser;
import org.openfast.template.loader.GroupParser;
import org.openfast.template.loader.MessageTemplateLoader;
import org.openfast.template.loader.ParsingContext;
import org.openfast.template.loader.ScalarParser;
import org.openfast.template.loader.SequenceParser;
import org.openfast.template.loader.StringParser;
import org.openfast.template.loader.TemplateParser;
import org.openfast.template.loader.TemplateRefParser;
import org.openfast.template.type.Type;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XMLMessageTemplateLoader
implements MessageTemplateLoader {
    static final String TEMPLATE_DEFINITION_NS = "http://www.fixprotocol.org/ns/fast/td/1.1";
    static final ErrorCode IO_ERROR = new ErrorCode(FastConstants.STATIC, -1, "IOERROR", "IO Error", FastAlertSeverity.ERROR);
    static final ErrorCode XML_PARSING_ERROR = new ErrorCode(FastConstants.STATIC, -1, "XMLPARSEERR", "XML Parsing Error", FastAlertSeverity.ERROR);
    static final ErrorCode INVALID_TYPE = new ErrorCode(FastConstants.STATIC, -1, "INVALIDTYPE", "Invalid Type", FastAlertSeverity.ERROR);
    private final boolean namespaceAwareness;
    private final ParsingContext initialContext;
    private boolean loadTemplateIdFromAuxId;

    public XMLMessageTemplateLoader() {
        this(false);
    }

    public XMLMessageTemplateLoader(boolean namespaceAwareness) {
        this.namespaceAwareness = namespaceAwareness;
        this.initialContext = XMLMessageTemplateLoader.createInitialContext();
    }

    public static ParsingContext createInitialContext() {
        ParsingContext initialContext = new ParsingContext();
        initialContext.setErrorHandler(ErrorHandler.DEFAULT);
        initialContext.setTemplateRegistry(new BasicTemplateRegistry());
        initialContext.setTypeMap(Type.getRegisteredTypeMap());
        initialContext.setFieldParsers(new ArrayList());
        initialContext.addFieldParser(new ScalarParser());
        initialContext.addFieldParser(new GroupParser());
        initialContext.addFieldParser(new SequenceParser());
        initialContext.addFieldParser(new ComposedDecimalParser());
        initialContext.addFieldParser(new StringParser());
        initialContext.addFieldParser(new ByteVectorParser());
        initialContext.addFieldParser(new TemplateRefParser());
        return initialContext;
    }

    public void addFieldParser(FieldParser fieldParser) {
        this.initialContext.getFieldParsers().add(fieldParser);
    }

    public MessageTemplate[] load(InputStream source) {
        Document document = this.parseXml(source);
        if (document == null) {
            return new MessageTemplate[0];
        }
        Element root = document.getDocumentElement();
        TemplateParser templateParser = new TemplateParser(this.loadTemplateIdFromAuxId);
        if (root.getNodeName().equals("template")) {
            return new MessageTemplate[]{(MessageTemplate)templateParser.parse(root, this.initialContext)};
        }
        if (root.getNodeName().equals("templates")) {
            ParsingContext context = new ParsingContext(root, this.initialContext);
            NodeList templateTags = root.getElementsByTagName("template");
            MessageTemplate[] templates = new MessageTemplate[templateTags.getLength()];
            int templatesToLoad = templates.length;
            int previousNumberOfTemplatesLeft = templates.length;
            while (templatesToLoad > 0) {
                int i = 0;
                while (i < templateTags.getLength()) {
                    Element templateTag;
                    MessageTemplate template;
                    if (templates[i] == null && (template = (MessageTemplate)templateParser.parse(templateTag = (Element)templateTags.item(i), context)) != null) {
                        templates[i] = template;
                        --templatesToLoad;
                    }
                    ++i;
                }
                if (previousNumberOfTemplatesLeft == templatesToLoad) {
                    throw new FastException("Unresolved static template references exist.", FastConstants.PARSE_ERROR);
                }
                previousNumberOfTemplatesLeft = templatesToLoad;
            }
            return templates;
        }
        this.initialContext.getErrorHandler().error(FastConstants.S1_INVALID_XML, "Invalid root node " + root.getNodeName() + ", \"template\" or \"templates\" expected.");
        return new MessageTemplate[0];
    }

    private Document parseXml(InputStream templateStream) {
        org.xml.sax.ErrorHandler errorHandler = new org.xml.sax.ErrorHandler(){

            public void error(SAXParseException exception) throws SAXException {
                XMLMessageTemplateLoader.this.initialContext.getErrorHandler().error(XML_PARSING_ERROR, "ERROR: " + exception.getMessage(), exception);
            }

            public void fatalError(SAXParseException exception) throws SAXException {
                XMLMessageTemplateLoader.this.initialContext.getErrorHandler().error(XML_PARSING_ERROR, "FATAL: " + exception.getMessage(), exception);
            }

            public void warning(SAXParseException exception) throws SAXException {
                XMLMessageTemplateLoader.this.initialContext.getErrorHandler().error(XML_PARSING_ERROR, "WARNING: " + exception.getMessage(), exception);
            }
        };
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setIgnoringElementContentWhitespace(true);
            dbf.setNamespaceAware(this.namespaceAwareness);
            DocumentBuilder builder = dbf.newDocumentBuilder();
            builder.setErrorHandler(errorHandler);
            InputSource inputSource = new InputSource(templateStream);
            Document document = builder.parse(inputSource);
            return document;
        }
        catch (IOException e) {
            this.initialContext.getErrorHandler().error(IO_ERROR, "Error occurred while trying to read xml template: " + e.getMessage(), e);
        }
        catch (Exception e) {
            this.initialContext.getErrorHandler().error(XML_PARSING_ERROR, "Error occurred while parsing xml template: " + e.getMessage(), e);
        }
        return null;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.initialContext.setErrorHandler(errorHandler);
    }

    public void setTemplateRegistry(TemplateRegistry templateRegistry) {
        this.initialContext.setTemplateRegistry(templateRegistry);
    }

    public TemplateRegistry getTemplateRegistry() {
        return this.initialContext.getTemplateRegistry();
    }

    public void setTypeMap(Map typeMap) {
        this.initialContext.setTypeMap(typeMap);
    }

    public void setLoadTemplateIdFromAuxId(boolean loadTempalteIdFromAuxId) {
        this.loadTemplateIdFromAuxId = loadTempalteIdFromAuxId;
    }
}

