/*
 * Decompiled with CFR 0.152.
 */
package org.openfast.examples.producer;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.openfast.Context;
import org.openfast.Global;
import org.openfast.Message;
import org.openfast.MessageOutputStream;
import org.openfast.error.ErrorHandler;
import org.openfast.examples.MessageBlockWriterFactory;
import org.openfast.examples.producer.XmlCompressedMessageConverter;
import org.openfast.session.Connection;
import org.openfast.session.ConnectionListener;
import org.openfast.session.Endpoint;
import org.openfast.session.FastConnectionException;
import org.openfast.template.TemplateRegistry;
import org.openfast.template.loader.XMLMessageTemplateLoader;

public class FastMessageProducer
implements ConnectionListener {
    protected final Endpoint endpoint;
    protected final TemplateRegistry templateRegistry;
    protected Thread acceptThread;
    protected List connections = new ArrayList();
    protected XmlCompressedMessageConverter converter = new XmlCompressedMessageConverter();
    protected final MessageBlockWriterFactory messageBlockWriterFactory;
    protected final boolean shouldResetOnEveryMessage;

    public FastMessageProducer(Endpoint endpoint, File templatesFile) {
        this(endpoint, templatesFile, new MessageBlockWriterFactory(), false);
    }

    public FastMessageProducer(Endpoint endpoint, File templatesFile, MessageBlockWriterFactory messageBlockWriterFactory, boolean shouldResetOnEveryMessage) {
        Global.setErrorHandler(ErrorHandler.NULL);
        this.endpoint = endpoint;
        XMLMessageTemplateLoader loader = new XMLMessageTemplateLoader();
        loader.setLoadTemplateIdFromAuxId(true);
        try {
            loader.load(new FileInputStream(templatesFile));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        this.templateRegistry = loader.getTemplateRegistry();
        this.converter.setTemplateRegistry(this.templateRegistry);
        this.messageBlockWriterFactory = messageBlockWriterFactory;
        this.shouldResetOnEveryMessage = shouldResetOnEveryMessage;
    }

    public void encode(File xmlDataFile) throws FastConnectionException, IOException {
        this.encode(new FileInputStream(xmlDataFile), true);
    }

    public void encode(InputStream xmlData) throws FastConnectionException, IOException {
        this.encode(xmlData, true);
    }

    public void encode(InputStream xmlData, boolean loopForever) throws FastConnectionException, IOException {
        List messages = this.converter.parse(xmlData);
        if (messages == null) {
            throw new IllegalArgumentException("The XML data stream contains no FAST messages!");
        }
        do {
            this.publish(messages, this.connections);
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (loopForever);
    }

    protected void publish(List messages, List msgOutputStreams) {
        int i = 0;
        while (i < messages.size()) {
            Message message = (Message)messages.get(i);
            int j = 0;
            while (j < msgOutputStreams.size()) {
                MessageOutputStream out = (MessageOutputStream)msgOutputStreams.get(j);
                out.writeMessage(message);
                if (this.shouldResetOnEveryMessage) {
                    out.reset();
                }
                ++j;
            }
            ++i;
        }
    }

    public void start() {
        System.out.println("Listening on " + this.endpoint);
        if (this.acceptThread != null) {
            return;
        }
        this.endpoint.setConnectionListener(this);
        this.acceptThread = new Thread("Producer Accept Thread"){

            public void run() {
                try {
                    FastMessageProducer.this.endpoint.accept();
                }
                catch (FastConnectionException e) {
                    System.out.println("Error occurred while listening for connections: " + e.getMessage());
                }
            }
        };
        this.acceptThread.start();
    }

    public void stop() {
        this.endpoint.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onConnect(Connection connection) {
        List list = this.connections;
        synchronized (list) {
            Context context = new Context();
            context.setErrorHandler(ErrorHandler.NULL);
            context.setTemplateRegistry(this.templateRegistry);
            try {
                MessageOutputStream out = new MessageOutputStream(connection.getOutputStream(), context);
                out.setBlockWriter(this.messageBlockWriterFactory.create());
                this.connections.add(out);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

