/*
 * Decompiled with CFR 0.152.
 */
package org.openfast.session.multicast;

import java.io.IOException;
import java.io.InputStream;
import java.net.DatagramPacket;
import java.net.MulticastSocket;
import java.nio.ByteBuffer;

public class MulticastInputStream
extends InputStream {
    private static final int BUFFER_SIZE = 65536;
    private final MulticastSocket socket;
    private final ByteBuffer buffer;

    public MulticastInputStream(MulticastSocket socket) {
        this(socket, 65536);
    }

    public MulticastInputStream(MulticastSocket socket, int bufferSize) {
        this.socket = socket;
        this.buffer = ByteBuffer.allocate(bufferSize);
        this.buffer.flip();
    }

    public int read() throws IOException {
        if (this.socket.isClosed()) {
            return -1;
        }
        if (!this.buffer.hasRemaining()) {
            this.buffer.clear();
            DatagramPacket packet = new DatagramPacket(this.buffer.array(), this.buffer.capacity());
            this.socket.receive(packet);
            this.buffer.flip();
            this.buffer.limit(packet.getLength());
        }
        return this.buffer.get() & 0xFF;
    }

    public int available() throws IOException {
        return this.buffer.remaining();
    }
}

