% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/popdynfun.r
\name{run.popgensim}
\alias{run.popgensim}
\title{Run forward step generations a popgen simulation}
\usage{
run.popgensim(simpops, steps, cost.mat, n.offspring, n.ind, mig.rate, disp.max,
  disp.rate, n.allels, mut.rate, n.cov = 3, rec = "none",
  emi.table = NULL)
}
\arguments{
\item{simpops}{pops object (a list of pop)}

\item{steps}{the number of steps (generations)}

\item{cost.mat}{a cost matrix (e.g. calculated via costDistance)}

\item{n.offspring}{number of offsprings per female}

\item{n.ind}{number of individuals}

\item{mig.rate}{migration rate}

\item{disp.max}{maximal dispersal distance of disp.rate individuals}

\item{disp.rate}{percentage of individuals achieving disp.max}

\item{n.allels}{number of maximal alleles at a loci}

\item{mut.rate}{mutation rate}

\item{n.cov}{number of covariates (defaults to 3)}

\item{rec}{switch if emigration matrix should be recorded, either "none" or "emi"}

\item{emi.table}{a emigration matrix, if provide a fixed number of migration events will take place otherwise based on disp.max, mig.rate and disp.rate, events occuring are (in that order, emigration, reproduction, mutation)}
}
\value{
an updated simpops object after steps steps
}
\description{
performs a time-forward, agent-based and spatiallly explicit genetic population simulation
}

