% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mf.R
\name{mf}
\alias{mf}
\title{The full  Fisher Information Matrix (FIM) for one individual}
\usage{
mf(model_switch, xt_ind, x, a, bpop, d, sigma, docc, poped.db)
}
\arguments{
\item{model_switch}{A vector that is the same size as xt, specifying which model each sample belongs to.}

\item{xt_ind}{A vector of sample times.}

\item{x}{A vector for the discrete design variables.}

\item{a}{A vector of covariates.}

\item{bpop}{The fixed effects parameter values.  Supplied as a vector.}

\item{d}{A between subject variability matrix (OMEGA in NONMEM).}

\item{sigma}{A residual unexplained variability matrix (SIGMA in NONMEM).}

\item{docc}{A between occasion variability matrix.}

\item{poped.db}{A PopED database.}
}
\value{
As a list:
\item{ret}{The FIM for one individual}
\item{poped.db}{A PopED database}
}
\description{
Compute the full  FIM for one individual given specific model(s), parameters, design and methods. 
This computation makes no assumption that fixed and random effects are uncorrelated.
}
\examples{
library(PopED)

############# START #################
## Create PopED database
## (warfarin example)
#####################################

## Warfarin example from software comparison in:
## Nyberg et al., "Methods and software tools for design evaluation 
##   for population pharmacokinetics-pharmacodynamics studies", 
##   Br. J. Clin. Pharm., 2014. 

## find the parameters that are needed to define from the structural model
ff.PK.1.comp.oral.sd.CL

## -- parameter definition function 
## -- names match parameters in function ff
sfg <- function(x,a,bpop,b,bocc){
  parameters=c(CL=bpop[1]*exp(b[1]),
               V=bpop[2]*exp(b[2]),
               KA=bpop[3]*exp(b[3]),
               Favail=bpop[4],
               DOSE=a[1])
  return(parameters) 
}

## -- Define initial design  and design space
poped.db <- create.poped.database(ff_file="ff.PK.1.comp.oral.sd.CL",
                                  fg_file="sfg",
                                  fError_file="feps.prop",
                                  bpop=c(CL=0.15, V=8, KA=1.0, Favail=1), 
                                  notfixed_bpop=c(1,1,1,0),
                                  d=c(CL=0.07, V=0.02, KA=0.6), 
                                  sigma=0.01,
                                  groupsize=32,
                                  xt=c( 0.5,1,2,6,24,36,72,120),
                                  minxt=0,
                                  maxxt=120,
                                  a=70)

############# END ###################
## Create PopED database
## (warfarin example)
#####################################


#for the FO approximation
ind=1

# no occasion defined in this example, so result is zero
output <- mf(model_switch=t(poped.db$design$model_switch[ind,,drop=FALSE]),
   xt_ind=t(poped.db$design$xt[ind,,drop=FALSE]),
   x=zeros(0,1),
   a=t(poped.db$design$a[ind,,drop=FALSE]),
   bpop=poped.db$parameters$bpop[,2,drop=FALSE],
   d=poped.db$parameters$param.pt.val$d,
   sigma=poped.db$parameters$sigma,
   docc=poped.db$parameters$param.pt.val$docc,
   poped.db)

# in this simple case the full FIM is just the sum of the individual FIMs
# and all the individual FIMs are the same
det(output$ret*32) == det(evaluate.fim(poped.db,fim.calc.type=0))  
}
\seealso{
Used by \code{\link{mftot0}}.

Other FIM: \code{\link{LinMatrixH}},
  \code{\link{LinMatrixLH}}, \code{\link{LinMatrixL_occ}},
  \code{\link{calc_ofv_and_fim}},
  \code{\link{ed_laplace_ofv}}, \code{\link{ed_mftot}},
  \code{\link{evaluate.e.ofv.fim}},
  \code{\link{evaluate.fim}}, \code{\link{gradf_eps}},
  \code{\link{mf3}}, \code{\link{mf5}}, \code{\link{mf6}},
  \code{\link{mf7}}, \code{\link{mf8}},
  \code{\link{mftot0}}, \code{\link{mftot1}},
  \code{\link{mftot2}}, \code{\link{mftot3}},
  \code{\link{mftot4}}, \code{\link{mftot5}},
  \code{\link{mftot6}}, \code{\link{mftot7}},
  \code{\link{mftot}}, \code{\link{ofv_criterion}},
  \code{\link{ofv_fim}}
}
\keyword{internal}

