% Generated by roxygen2 (4.0.2): do not edit by hand
\name{mftot6}
\alias{mftot6}
\title{The full Fisher Information Matrix (FIM) Calculating one model switch at a time, good for large matrices.}
\usage{
mftot6(model_switch, groupsize, ni, xt, x, a, bpop, d, sigma, docc, poped.db)
}
\arguments{
\item{model_switch}{A matrix that is the same size as xt, specifying which model each sample belongs to.}

\item{groupsize}{A vector of the numer of individuals in each group.}

\item{ni}{A vector of the number of samples in each group.}

\item{xt}{A matrix of sample times.  Each row is a vector of sample times for a group.}

\item{x}{A matrix for the discrete design variables.  Each row is a group.}

\item{a}{A matrix of covariates.  Each row is a group.}

\item{bpop}{The fixed effects parameter values.  Supplied as a vector.}

\item{d}{A between subject variability matrix (OMEGA in NONMEM).}

\item{sigma}{A residual unexplained variability matrix (SIGMA in NONMEM).}

\item{docc}{A between occasion variability matrix.}

\item{poped.db}{A PopED database.}
}
\value{
As a list:
\item{ret}{The FIM}
\item{poped.db}{A PopED database}
}
\description{
Compute the full FIM given specific model(s), parameters, design and methods.
This computation calculates the FIM for each model switch separately.  Correlations between the models parameters are assumed to be zero.
}
\examples{
## Warfarin example from software comparison in:
## Nyberg et al., "Methods and software tools for design evaluation 
##   for population pharmacokinetics-pharmacodynamics studies", 
##   Br. J. Clin. Pharm., 2014. 

## Optimization using an additive + proportional reidual error to 
##   avoid sample times at very low concentrations (time 0 or very late samoples).
library(PopED)

## find the parameters that are needed to define from the structural model
ff.PK.1.comp.oral.sd.CL

## -- parameter definition function 
## -- names match parameters in function ff
sfg <- function(x,a,bpop,b,bocc){
  parameters=c(CL=bpop[1]*exp(b[1]),
               V=bpop[2]*exp(b[2]),
               KA=bpop[3]*exp(b[3]),
               Favail=bpop[4],
               DOSE=a[1])
  return(parameters) 
}

## -- Define initial design  and design space
poped.db <- create.poped.database(ff_file="ff.PK.1.comp.oral.sd.CL",
                                  fg_file="sfg",
                                  fError_file="feps.add.prop",
                                  bpop=c(CL=0.15, V=8, KA=1.0, Favail=1), 
                                  notfixed_bpop=c(1,1,1,0),
                                  d=c(CL=0.07, V=0.02, KA=0.6), 
                                  sigma=c(0.01,0.25),
                                  groupsize=32,
                                  xt=c( 0.5,1,2,6,24,36,72,120),
                                  minxt=0,
                                  maxxt=120,
                                  a=70,
                                  mina=0,
                                  maxa=100)
# warfarin optimization model



mftot6(model_switch=poped.db$global_model_switch,
      groupsize=poped.db$groupsize,
      ni=poped.db$gni,
      xt=poped.db$gxt,
      x=poped.db$gx,
      a=poped.db$ga,
      bpop=poped.db$param.pt.val$bpop,
      d=poped.db$param.pt.val$d,
      sigma=poped.db$sigma,
      docc=poped.db$param.pt.val$docc,
      poped.db)["ret"]

}
\seealso{
For an easier function to use, please see \code{\link{evaluate.fim}}.

Other FIM: \code{\link{LinMatrixH}};
  \code{\link{LinMatrixLH}}; \code{\link{LinMatrixL_occ}};
  \code{\link{calc_ofv_and_fim}};
  \code{\link{ed_laplace_ofv}}; \code{\link{ed_mftot}};
  \code{\link{evaluate.e.ofv.fim}};
  \code{\link{evaluate.fim}}; \code{\link{gradf_eps}};
  \code{\link{mf3}}; \code{\link{mf5}}; \code{\link{mf6}};
  \code{\link{mf7}}; \code{\link{mf8}};
  \code{\link{mftot0}}; \code{\link{mftot1}};
  \code{\link{mftot2}}; \code{\link{mftot3}};
  \code{\link{mftot4}}; \code{\link{mftot5}};
  \code{\link{mftot7}}; \code{\link{mftot}};
  \code{\link{mf}}; \code{\link{ofv_criterion}};
  \code{\link{ofv_fim}}
}

