% Generated by roxygen2 (4.0.1): do not edit by hand
\name{phenotPPE}
\alias{phenotPPE}
\title{Simple paternity exclusion for phenotype allele data}
\usage{
phenotPPE(adata)
}
\arguments{
\item{adata}{data frame: the preprocessed allele data set
returned by either \code{\link{inputData}} or
\code{\link{preprocessData}}.}
}
\value{
A list whose components are described below.  The
components that are probably of primary interest to the user are
\code{adultTables$FLCount} and \code{adultTables$VLTotal}.  These
are likely to be large tables, so note that the functions
\code{\link{potentialFatherCounts}} and
\code{\link{potentialFatherIDs}} are available to usefully
summarise their content.

The list returned by \code{phenotPPE} contains two elements,
\code{progenyTables} and \code{adultTables}, each of which are
themselves lists.

\code{adultTables} contains the following components:

\describe{

\item{\code{FLCount}}{Father Loci Count - a matrix, showing for
each progeny-candidate combination, the number of loci at which
the candidate matches (i.e., could have fathered) the progeny}

\item{\code{VLTotal}}{Valid Loci Total - a matrix, showing for
each progeny-candidate combination, the total number of loci at
which a valid comparison between progeny and candidate could be
made.  (Missing allele sets, whether in the original data, or due
to progeny-mother mismatches found by \code{\link{preprocessData}}
can result in fewer loci at which progeny-candidate (father)
comparisons are possible.)}

\item{\code{fatherSummaryTable}}{A matrix, combining the results
of \code{FLCount} and \code{VLTotal} (see above) for each
progeny-candidate combination in one table.  This is purely for
ease of viewing purposes, but note also the functions
\code{\link{potentialFatherCounts}} and
\code{\link{potentialFatherIDs}} which may provide more useful
summary output.}

\item{\code{CPNotM.alleleArray}}{A 3D array containing the
alleles present in both candidate (father) and progeny, but not in
the progeny's mother (for each progeny/candidate/locus
combination)}

\item{\code{CMP.alleleArray}}{A 3D array containing the alleles
present in candidate, progeny and progeny's mother (for each
progeny/candidate/locus combination)}

\item{\code{simpleFatherArray}}{A 3D array indicating whether each
candidate is compatible with each progeny, for each locus}

}

\code{progenyTables} contains the following components:

\describe{

\item{\code{progenyStatusTable}}{A data frame, indicating the
status of the progeny / mother allele set comparison (for each
progeny, at each locus).}

\item{\code{MP.alleleTable}}{A data frame containing the alleles
that are found in both mother's and progeny's allele sets (for
each progeny, at each locus)}

\item{\code{PNotM.alleleTable}}{A data frame, containing the
alleles in the progeny's allele set, that are \emph{not} present
in the mother's allele set(for each progeny, at each locus)}

}

The status codes in \code{progenyTables$progenyStatusTable} are:

\describe{

\item{\code{"MAO"}}{Mother Alleles Only - the progeny contains
only alleles found also in the mother}

\item{\code{"NMA"}}{Non-Mother Alleles - the progeny contains
alleles that are not found in the mother}

\item{\code{"P.missing"}}{No comparison was possible at this locus
because the progeny's allele set was missing}

\item{\code{"P.missing"}}{No comparison was possible at this locus
because the mother's allele set was missing}

\item{\code{"PM.missing"}}{No comparison was possible at this
locus because both progeny's and mother's allele sets were
missing}

}

Note that some of the \code{"P.missing"} or \code{"PM.missing"}
codes may have arisen due to progeny / mother mismatches found
(and corresponding progeny allele sets removed) by
\code{\link{preprocessData}}.
}
\description{
Conduct a paternity exclusion analysis on a phenotype dataset.
}
\details{
\code{phenotPPE} conducts a basic paternity exclusion analysis on
a \sQuote{phenotype} dataset.

For the purposes of the PolyPatEx package, the term
\sQuote{phenotype} refers to forms of marker data where the allele
dosages (or multiplicities) are not known - hence for a polyploid
species of ploidy \emph{p}, a valid allele set may contain between
one and \emph{p} alleles, which should all be distinct.  Any cases
of allele sets having duplicated alleles will have previously been
caught by \code{\link{preprocessData}} (automatically called by
\code{\link{inputData}}) and will have produced an error message,
requiring the user to remove any duplicated alleles (within allele
sets) in the original data file).

For the above and other reasons, \code{phenotPPE} should
\bold{NOT} be applied to a dataset that has not been preprocessed
by \code{\link{preprocessData}} (either by calling
\code{\link{preprocessData}} on the allele data frame directly, or
by loading the allele data into R using \code{\link{inputData}}).
}
\examples{
## Using the example dataset 'GF_Phenotype':
data(GF_Phenotype)

## Since we did not load this dataset using inputData(), we must
## first process it with preprocessData() before doing anything
## else:
pData <- preprocessData(GF_Phenotype,
                        numLoci=7,
                        ploidy=6,
                        dataType="phenotype",
                        dioecious=FALSE,
                        selfCompatible=FALSE)

pPPE <- phenotPPE(pData)

## pPPE is a large (and rather ugly!) data structure - see
## functions potentialFatherCounts() and potentialFatherIDs() for
## more useful output from the gPPE object.
}
\author{
Alexander Zwart (alec.zwart at csiro.au)
}
\seealso{
\code{\link{genotPPE}}
}

