% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VDJ_tree.R
\name{VDJ_tree}
\alias{VDJ_tree}
\title{Platypus V2 phylogenetic trees.}
\usage{
VDJ_tree(
  clonal.lineages,
  with.germline,
  min.sequences,
  max.sequences,
  normalize.germline.length,
  unique.sequences
)
}
\arguments{
\item{clonal.lineages}{Output from VDJ_clonal_lineages. This should be nested list, with the outer list element corresponding to the individual repertoire and the inner list corresponding to individual clonal lineages based on the initial clonotyping strategy in the form of a dataframe with either Seq or Name.}

\item{with.germline}{Logical specifying if the germline should be set as outgroup. Default is set to TRUE.}

\item{min.sequences}{integer value specifying the minimum number of sequences to be allowed for clonal lineages. Default is 3.}

\item{max.sequences}{integer value specifying the maximum number of sequences to be allowed for clonal lineages. Default is 500}

\item{normalize.germline.length}{Logical determining whether or not the branch length separating the germline from the first internal node should be normalized. Potentially useful for visualization if the remainder tips are far from the root. Default is TRUE.}

\item{unique.sequences}{Logical indicating if those cells containing identical VDJRegion sequences should be merged into single nodes and have their variant added as the tip label. Default is TRUE.}
}
\value{
Returns a nested list of phylogenetic trees. The output[[i]][[j]] corresponds to the j'th clone in the i'th input repertoire. plot(output[[i]][[j]]) should display the phylogenetic tree if the ape package is loaded.
}
\description{
Please refer tp VDJ_phylogenetic_tree for Platypus V3. Produces neighbor joining phylogenetic trees from the output of VDJ_clonal_lineages
}
\examples{
\dontrun{
vdj.tree <- VDJ_tree(clonal.lineages = VDJ.clonal.lineage.output
,with.germline=TRUE,min.sequences = 5
,max.sequences = 30,unique.sequences = TRUE)
}
}
