% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VDJ_expand_aberrants.R
\name{VDJ_expand_aberrants}
\alias{VDJ_expand_aberrants}
\title{Expand the aberrant cells in a VDJ dataframe by converting them into additional rows}
\usage{
VDJ_expand_aberrants(
  VDJ,
  chain.to.expand,
  add.barcode.prefix,
  additional.VDJ.features,
  additional.VJ.features,
  add.CDR3aa,
  add.expanded.number,
  recalculate.clonotype.frequency
)
}
\arguments{
\item{VDJ}{VDJ or VDJ.GEX.matrix[[1]] object, as obtained from the VDJ_GEX_matrix function in Platypus.}

\item{chain.to.expand}{string, 'VDJ' to expand VDJ aberrants, 'VJ' to expand VJ aberrants, 'VDJ.VJ' for both.}

\item{add.barcode.prefix}{boolean - if T, a new barcode will be added for each expanded aberrant.}

\item{additional.VDJ.features}{vector of strings - VDJ_expand_aberrants will only expand across the sequence columns of VDJ. If you have additional columns with aberrant cell features (e.g., both 'yes' and 'no' binders for a single sequence), where the aberrants are VDJ-specific, include them here.}

\item{additional.VJ.features}{vector of strings - VDJ_expand_aberrants will only expand across the sequence columns of VDJ. If you have additional columns with aberrant cell features (e.g., both 'yes' and 'no' binders for a single sequence), where the aberrants are VJ-specific, include them here.}

\item{add.CDR3aa}{boolean - if T, will create a new column 'CDR3aa' with pasted VDJ_cdr3s_aa and VJ_cdr3s_aa.}

\item{add.expanded.number}{boolean - if T, will add the number of new cells resulting from an aberrant one.}

\item{recalculate.clonotype.frequency}{boolean - if T, will recalculate the clonotype frequencies for the resulting, expanded VDJ.}
}
\value{
Returns a VDJ format dataframe in which cells with more than one VDJ or VJ chain are split into multiple rows each containing only one VDJ VJ chain combination.
}
\description{
Expand the aberrant cells in a VDJ dataframe by converting them into additional rows. Aberrant cells consist of cells with more than 1 VDJ or VJ chain.
}
\examples{
VDJ_expand_aberrants(VDJ = small_vgm[[1]],
chain.to.expand='VDJ.VJ',
add.barcode.prefix=TRUE, recalculate.clonotype.frequency=FALSE)

}
