% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VDJ_db_annotate.R
\name{VDJ_db_annotate}
\alias{VDJ_db_annotate}
\title{Wrapper function of VDJ_antigen_integrate function}
\usage{
VDJ_db_annotate(VDJ, db.list, database.features, match, homology, lv.distance)
}
\arguments{
\item{VDJ}{VDJ or VDJ.GEX.matrix[[1]] object, as obtained from the VDJ_GEX_matrix function in Platypus.}

\item{db.list}{list of database dataframes or csv file paths, obtained from VDJ_db_load with .}

\item{database.features}{list of features/column names to be integrated from the databases.}

\item{match}{string - sequences by which to match and integrate the antigen information. Currently, only 'cdr3.aa' and 'cdrh3.aa' are supported, as all databases have these two sequence types ('VJ_cdr3s_aa','VDJ_cdr3s_aa').}

\item{homology}{string - 'exact' for exact sequence matchings, 'homology' for homology matching.}

\item{lv.distance}{integer - maximum Levehnstein distance threshold for the homology matchings.}
}
\value{
VDJ with new columns - antigen information integrated from the antigen databases.
}
\description{
Wraps the VDJ_antigen_integrate function and uses it to annotate a VDJ dataframe with antigen information. Needs to VDJ_db_load to be executed first, with preprocess=T and vgm.names=T to obtain the same column names as in the VDJ (to allow for sequence matching).
}
\examples{
\dontrun{
VDJ_db_annotate(VDJ=VDJ,db.list=db.list,database.features='Epitope',match='cdr3.aa',homology=FALSE)
}
}
