% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate.R
\name{compute_expectations.BM}
\alias{compute_expectations.BM}
\title{Compute the expected states of a BM}
\usage{
compute_expectations.BM(phylo, root.state, shifts, U_tree = NULL)
}
\arguments{
\item{root.state}{(list): state of the root, with:
random : random state (TRUE) or deterministic state (FALSE)
value.root : if deterministic, value of the character at the root
exp.root : if random, expectation of the character at the root
var.root : if random, variance of the character at the root (pxp matrix)}

\item{shifts}{(list) position and values of the shifts :
edges : vector of the K id of edges where the shifts are
values : matrix p x K of values of the shifts on the edges (one column = one shift)
relativeTimes : vector of dimension K of relative time of the shift from the
parent node of edges}

\item{phylo:}{Input tree.}
}
\value{
paramSimu: array p x Nnode x 2 (BM). For each trait t, 1 <= t <= p,
 paramSimu[t, , ] has two columns, both containing the expected values for
 all the nodes.
}
\description{
\code{compute_expectations.BM} use the matrix formulation to compute the 
expected values at all the nodes.
}
\keyword{internal}
