% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parsimonyNumber.R
\name{equivalent_shifts_values}
\alias{equivalent_shifts_values}
\title{Find values given edges. OU stationary case. Ultrametric tree.}
\usage{
equivalent_shifts_values(phylo, eq_shifts_edges, T_tree_ac, vect_Y, p)
}
\arguments{
\item{phylo}{a phylogenetic tree, class \code{\link[ape]{phylo}}.}

\item{eq_shifts_edges}{matrix (optional) result of function
\code{\link{equivalent_shifts_edges}}.}

\item{T_tree_ac}{matrix of incidence of the tree, result of function 
\code{\link{incidence.matrix}}, actualized with coefficients computed by
function \code{\link{incidence_matrix_actualization_factors}}.}

\item{shifts}{a list of positions and values of original shifts.}

\item{beta_0}{value of the original optimal value at the root.}
}
\value{
Named list, with "shifts_values" a matrix of shifts values
corresponding to the shifts positions in eq_shifts_edges; and "betas_0" a
vector of corresponding root optimal values.
}
\description{
\code{equivalent_shifts_values} computes the values of the shifts given all
the possible allocations computed by function
\code{\link{equivalent_shifts_edges}}.
}
\details{
This function uses the linear representation of the problem. It fist compute
the mean at the tips given by the orginal shifts positions and values, and
then uses function \code{\link{qr.solve}}
to find back the values of the shifts, given their various positions,
and the means at the tips. Function \code{compute_actualization_factors} is
used to compute the actualization factor that multiplies the shifts values at
the tips. Careful, only works for ULTRAMETRIC trees.
}
\keyword{internal}
