% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimateEM.R
\name{params_process.PhyloEM}
\alias{params_process.PhyloEM}
\title{Parameter estimates}
\usage{
\method{params_process}{PhyloEM}(x, method.selection = NULL, K = NULL,
  alpha = NULL, rBM = FALSE, init = FALSE, ...)
}
\arguments{
\item{x}{an object of class \code{\link{PhyloEM}}}

\item{method.selection}{(optional) the method selection to be used.
One of "LINselect", "DDSE", "Djump". Default to "LINselect".}

\item{K}{(optional) an integer giving the number of shifts for which to retrieve
the parameters. Default to NULL (automatically selected number of shifts, see
\code{method.selection} argument).}

\item{alpha}{(optional) a value of alpha for which to retrieve the parameters. Can
be an (un-ambiguous) estimation of the true value. If
specified, then \code{K} must be precised too. Default to NULL (automatically
selected value, see \code{method.selection} argument).}

\item{rBM}{(optional) if TRUE, and if the process is "scOU", returns the raw
parameters of the BM on the re-scaled tree. Default to FALSE.}

\item{init}{(optional) if TRUE, gives the parameters from the initialization of
the EM. Default to FALSE. This has no effect if \code{K} is not specified.}

\item{...}{unused.}
}
\value{
An object of class \code{\link{params_process}}.
}
\description{
\code{params} takes an object of class \code{\link{PhyloEM}}, and returns the 
inferred parameters of the process.
}
\seealso{
\code{\link{PhyloEM}}, \code{\link{imputed_traits.PhyloEM}}
}
