% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/savePhytree.R
\name{savePhytree}
\alias{savePhytree}
\title{Save a Phylogenetic Tree Object}
\usage{
savePhytree(
  phyloTree,
  specimen_dataframe,
  label_offset = 5.5e-05,
  label_size = 0.3,
  tree_file_name = "Phylogenetic_Tree.pdf",
  openPDF = FALSE,
  savePDF = FALSE
)
}
\arguments{
\item{phyloTree}{A phylo tree object.}

\item{specimen_dataframe}{A specimen dataframe.}

\item{label_offset}{A numerical value to set the label offset distance.}

\item{label_size}{A numerical value to set the label size.}

\item{tree_file_name}{An optional character string to name the PDF file.}

\item{openPDF}{A logical value to state whether to open the PDF file.}

\item{savePDF}{A logical value to state whether to save the PDF file to the working directory. If FALSE the file will be saved to a temporary directory but will still be able to open.}
}
\value{
A PDF file.
}
\description{
Create a phylogenetic tree PDF using a phylo tree object and a specimen dataframe.
}
\examples{
# create and plot a phylo tree
specdf_Anth <- querySpecData("Antheraea polyphemus")[1:10,]

DNABin_Anth <- genDNABin(specdf_Anth)

DNAStringset_Anth <- genDNAStringSet(DNABin_Anth)

DNAStringSet_Anth_manipulated <- ManipStringSet(DNAStringset_Anth)

Phytree_Anth <- genPhytree(DNAStringSet_Anth_manipulated)

savePhytree(
 phyloTree = Phytree_Anth,
 specimen_dataframe = specdf_Anth,
 tree_file_name = "Anth_phylo_tree.pdf",
 openPDF = FALSE,
 savePDF = FALSE
)
}
