\name{parallel.cluster.signal.noise}
\alias{parallel.cluster.signal.noise}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Quantify Quartet Resolution Probabilities Using 2012 Formulation and MCMC approach in parallel
}
\description{
Quantify Quartet Resolution Probabilities (QIRP, QIHP, and QIPP) Using 2012 Formulation and MCMC approach, outputs results to file
}
\usage{
parallel.cluster.signal.noise(t, t0, 
rateVector, nsims, s, filename, imagename, 
image = "TRUE")
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{t}{
Time from tip of tree to focal internode 
}
  \item{t0}{
 Focal internode length 
}
  \item{rateVector}{
%%     An object containing a vector of site rates transformed to class "matrix" 
}
  \item{nsims}{
%%     number of simulations
}
  \item{s}{
A number representing the character state space that generated the site rates (e.g., s=2 for binary data)
}
  \item{filename}{
Output file name for results of calculation
}
  \item{imagename}{
Output file name for results of visualization
}
  \item{image}{
True or False if image should visualized
}
}
\details{
Please note that the two files must have different names
}
\value{
returns QIRP, QIHP, and QIPP values

}
\references{
Townsend, J. P., Su, Z., and Tekle, Y. I. “Phylogenetic Signal and Noise: Predicting the Power of a Data Set to Resolve Phylogeny” Systematic biology 61, no. 5 (2012): 835–849. }
\author{
A. Dornburg
}


\examples{
library("doParallel")
#Cores must be less than or equal to those had on your machine.
#registerDoParallel(cores=2)
as.matrix(rag1)->rr
parallel.cluster.signal.noise(100, 2, rr, 10, 3,
filename="output_values", imagename="output_graphic", image = "TRUE") 
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ ~kwd1 }% use one of  RShowDoc("KEYWORDS")
\keyword{ ~kwd2 }% __ONLY ONE__ keyword per line
