% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/drugSensitivitySig.R
\name{drugSensitivitySig}
\alias{drugSensitivitySig}
\title{Creates a signature representing the association between gene expression (or
other molecular profile) and drug dose response, for use in drug sensitivity
analysis.}
\usage{
drugSensitivitySig(pSet, molecularData = c("rna", "dna", "snp", "cnv"), drugs,
  sensitivity.measure = c("ic50_published", "auc_published",
  "ic50_recomputed", "auc_recomputed"), duplicates = "median",
  returnValues = c("estimate", "tstat", "pvalue", "fdr"), nbcore = 1,
  verbose = FALSE)
}
\arguments{
\item{pSet}{\code{PharmacoSet} of the perturbation experiment type}

\item{molecularData}{\code{character} string, which one of the molecular data
types to use in the analysis, out of DNA, RNA, SNP, CNV}

\item{drugs}{\code{character} vector of drug names for which to compute the
signatures. Should match the names used in the PharmacoSet.}

\item{sensitivity.measure}{\code{character} string, idetifying which measure
of the drug dose sensitivity should the function use for its computations?
The current choices are 'ic50_published', 'auc_published',
'ic50_recomputed', 'auc_recomputed'.}

\item{duplicates}{\code{character} string, identifying which summary
statistic should be used to summarize duplicates for cell line sensitivity
measurements? Currently implemented is only the median.}

\item{returnValues}{\code{character} vector, detailing which of estimate,
t-stat, p-value and fdr should the function return for each gene drug pair?}

\item{nbcore}{\code{numeric}, if multiple cores are available, how many cores
should the computation be parallelized over?}

\item{verbose}{\code{bool} Should the function print diagnostic messages?}
}
\value{
A 3D \code{array} with genes in the first dimension, drugs in the
  second, and return values in the third.
}
\description{
Given a Pharmacoset of the sensitivity experiment type, and a list of drugs,
the function will compute a signature for the effect gene expression on the
molecular profile of a cell. The function returns the estimated coefficient,
the t-stat, the p-value and the false discovery rate associated with that
coefficient, in a 3 dimensional array, with genes in the first direction,
drugs in the second, and the selected return values in the third.
}

