% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/countPaths.R
\name{countPaths}
\alias{countPaths}
\title{count paths between all pairs}
\usage{
countPaths(conf, maxLength = 2)
}
\arguments{
\item{conf}{a matrix of conf.mat class.
An N-by-N conflict matrix whose \code{(i,j)}th element is the number of times i defeated j.}

\item{maxLength}{a positive numeric integer indicating the maximum length of paths to identify}
}
\value{
A list in which elements are number of paths between all pairs of a given length.
}
\description{
\code{countPaths} Identifies the number of paths of length
less than or equal to \code{maxLength} between all pairs
}
\examples{
# convert an edgelist to conflict matrix
confmatrix <- as.conflictmat(sampleEdgelist)
# find number of paths of length 3 or less
npaths <- countPaths(confmatrix, 3)
}
\seealso{
\code{\link{as.conflictmat}}, \code{\link{findIDpaths}}, \code{\link{transitivity}}, \code{\link{conductance}}
}

