% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PerMallows.R
\name{count.perms}
\alias{count.perms}
\title{Count permutations at a distance}
\usage{
count.perms(perm.length, dist.value, dist.name = "kendall", disk = FALSE)
}
\arguments{
\item{perm.length}{number of items in the permutations}

\item{dist.value}{the distance}

\item{dist.name}{optional. One of: kendall (default), cayley, hamming, ulam}

\item{disk}{optional can only be true if counting the permutations at each Ulam distance.
Insted of generating the whole set of SYT and count of permutations per distance, it loads the info from a file in the disk}
}
\value{
The number of permutations at the given distance
}
\description{
Given a distance (kendall, cayley, hamming or ulam), 
the number of items in the permutations perm.length and distance value d, 
how many permutations are there at distance d from any permutation?
It can be used to count the number of derangements and the permutations 
with k cycles (Stirling numbers of the first kind)
}
\examples{
count.perms(4,2,"kendall")
count.perms(4,2,"ulam")
count.perms(4,2,"hamming")
count.perms(4,2,"cayley")
# The number of derangements of length 6 is computed as follows
len <- 6
count.perms(perm.length = len, dist.value = len, dist.name = "h") 
# The number of permutations with one cycle is computed as follows
num.cycles <- 1 
count.perms(perm.length = len, dist.value = len - num.cycles, dist.name = "c") 
}

