% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gtResult.R
\name{gtResult}
\alias{gtResult}
\title{Create a gt table from a summary object.}
\usage{
gtResult(
  summarisedResult,
  long,
  wide,
  format = c(`N (\%)` = "count (percentage\%)", "median [min; q25 - q75; max]",
    "mean (sd)", "median [q25 - q75]", N = "count"),
  keepNotFormatted = TRUE,
  decimals = c(default = 0),
  decimalMark = ".",
  bigMark = ","
)
}
\arguments{
\item{summarisedResult}{A SummarisedResult object.}

\item{long}{List of variables and specification to long.}

\item{wide}{List of variables and specification to wide.}

\item{format}{formats and labels to use.}

\item{keepNotFormatted}{Whether to keep not formatted estimate types.}

\item{decimals}{Decimals per estimate_type.}

\item{decimalMark}{decimal mark.}

\item{bigMark}{big mark.}
}
\value{
A formatted summarisedResult gt object.
}
\description{
`r lifecycle::badge("deprecated")`
}
\examples{
\donttest{
library(PatientProfiles)

cdm <- mockPatientProfiles()

cdm$cohort1 \%>\%
  summariseCharacteristics(
    ageGroup = list(c(0, 19), c(20, 39), c(40, 59), c(60, 79), c(80, 150))
  )
CDMConnector::cdmDisconnect(cdm = cdm)
}

}
