% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plotting.R
\name{outcomeSurvivalPlot}
\alias{outcomeSurvivalPlot}
\title{Plot the outcome incidence over time}
\usage{
outcomeSurvivalPlot(
  plpData,
  outcomeId,
  populationSettings = createStudyPopulationSettings(binary = TRUE, includeAllOutcomes =
    TRUE, firstExposureOnly = FALSE, washoutPeriod = 0, removeSubjectsWithPriorOutcome =
    TRUE, priorOutcomeLookback = 99999, requireTimeAtRisk = FALSE, riskWindowStart = 1,
    startAnchor = "cohort start", riskWindowEnd = 3650, endAnchor = "cohort start"),
  riskTable = TRUE,
  confInt = TRUE,
  yLabel = "Fraction of those who are outcome free in target population"
)
}
\arguments{
\item{plpData}{The plpData object returned by running getPlpData()}

\item{outcomeId}{The cohort id corresponding to the outcome}

\item{populationSettings}{The population settings created using \code{createStudyPopulationSettings}}

\item{riskTable}{(binary) Whether to include a table at the bottom  of the plot showing the number of people at risk over time}

\item{confInt}{(binary) Whether to include a confidence interval}

\item{yLabel}{(string) The label for the y-axis}
}
\value{
A \code{ggsurvplot} object
}
\description{
Plot the outcome incidence over time
}
\details{
This creates a survival plot that can be used to pick a suitable time-at-risk period
}
\examples{
\dontshow{if (rlang::is_installed("survminer")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
data("simulationProfile")
plpData <- simulatePlpData(simulationProfile, n=1000)
plotObject <- outcomeSurvivalPlot(plpData, outcomeId = 3)
print(plotObject)
\dontshow{\}) # examplesIf}
}
