% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_covid.R
\name{load_covid}
\alias{load_covid}
\title{Load Covid-19 Data}
\source{
\url{https://github.com/CSSEGISandData/COVID-19}\cr
\url{https://github.com/covid19br/covid19br.github.io}
}
\usage{
load_covid(country_name, state_name = NULL, last_date)
}
\arguments{
\item{country_name}{string specifying the country of interest.
Check \code{country_list()} for the list of countries available in the database.}

\item{state_name}{optional string specifying the state of interest - only brazilian states currently
available in the database. \code{state_name} should be either \code{NULL} or a string of length 2.
Check \code{state_list()} for the state abbreviations that will be used and the corresponding state names.}

\item{last_date}{optional date, character or factor argument specifying the last date in the data.
It should be in the YYYY-MM-DD or YYYY/MM/DD format. The default is the most recent date available in the database.}
}
\value{
An object of S3 class \code{pandemicData}. It is a list with 3 items:
\describe{
  \item{\code{data}:}{ data frame with the number of cumulative cases, new cases, cumulative deaths and new deaths associated
  with Covid-19 for each date, up to the \code{last_date} in the specified region.}
  \item{\code{name}:}{ string with the country name (and state name, if available).}
  \item{\code{population}:}{numeric object that contains the population size of the given region.}
}
}
\description{
This function pulls Covid-19 data up to a certain date, for a specified country (and state, if \code{country_name = "Brazil"}).
The output of this function is in the correct format to be used directly into the model adjustment function
\code{\link{pandemic_model}} included in this package.

The user must be online for this function to work.
}
\examples{
\dontrun{
load_covid("Brazil","MG")
load_covid(country_name = "India", last_date = "2020-06-15")
load_covid("US")
load_covid(country_name = "italy")}

}
\references{
CovidLP Team, 2020. CovidLP: Short and Long-term Prediction for COVID-19. Departamento de Estatistica. UFMG,
Brazil. URL: \url{http://est.ufmg.br/covidlp/home/en/}
}
\seealso{
\code{\link{country_list}}, \code{\link{state_list}},  \code{\link{pandemic_model}},
\code{\link{posterior_predict.pandemicEstimated}}, \code{\link{pandemic_stats}} and
\code{\link{plot.pandemicPredicted}}.
}
