% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PakPC2017Pak.R
\docType{data}
\name{PakPC2017Pak}
\alias{PakPC2017Pak}
\title{Pakistan data from Pakistan Population Census 2017}
\format{A \code{data.table} and  \code{data.frame} with 12 obs. of  10 variables.}
\usage{
data(PakPC2017Pak)
}
\description{
\code{PakPC2017Pak} Pakistan data from Pakistan Population Census 2017.
}
\details{
\itemize{
       \item AdminUnits Administrative Units of Pakistan
       \item ResStatus Residental Status
       \item Households No. of Households
       \item Male Male Population
       \item Female Female Population
       \item Transgender Transgender Population
       \item Pop2017 Total Population in 2017
       \item Pop1998 Total Population in 1998
       \item SexRatio2017 Sex Ration accoring to Pakistan Population Census 2017
       \item GrowthRate 1998-2017 Average Annual Growth Rate
       }
}
\examples{
data(PakPC2017Pak)
library(data.table)
PakPC2017Res <- 
          c(
              "Households", "Male", "Female", "Transgender"
            , "Pop2017", "Pop1998", "SexRatio2017", "GrowthRate"
            )


PakPC2017Pak[
       , j        = lapply(.SD, sum, na.rm = TRUE) 
       , by       = .(AdminUnits)
       , .SDcols  = PakPC2017Res
       ][order(AdminUnits)]

}
\references{
\enumerate{
\item Pakistan Population Census 2017 (\url{http://www.pbscensus.gov.pk/}).
 }
}
\seealso{
, \code{\link{PakPC2017Balochistan}}
   \code{\link{PakPC2017City10}}
 , \code{\link{PakPC2017FATA}}
 , \code{\link{PakPC2017Islamabad}}
 , \code{\link{PakPC2017KPK}}
 , \code{\link{PakPC2017Pak}}
 , \code{\link{PakPC2017Punjab}}
 , \code{\link{PakPC2017Sindh}}
}
\author{
Muhammad Yaseen (\email{myaseen208@gmail.com})
}
\keyword{datasets}
