% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/monitor_dailyStatisticList.R
\name{monitor_dailyStatisticList}
\alias{monitor_dailyStatisticList}
\title{Calculate Daily Statistics}
\usage{
monitor_dailyStatisticList(
  ws_monitor,
  FUN = get("mean"),
  dayStart = "midnight",
  na.rm = TRUE,
  minHours = 18
)
}
\arguments{
\item{ws_monitor}{\emph{ws_monitor} object}

\item{FUN}{function used to collapse a day's worth of data into a single number for each monitor in the ws_monitor object}

\item{dayStart}{one of \code{sunset|midnight|sunrise}}

\item{na.rm}{logical value indicating whether NA values should be ignored}

\item{minHours}{minimum number of valid data hours required to calculate each daily statistic}
}
\value{
A list of \emph{ws_monitor} objects with daily statistics for each local timezone.
}
\description{
Calculates daily statistics for each monitor in \code{ws_monitor}.
}
\details{
Splits the \code{ws_monitor} object by \code{timezone} and applies the
\code{monitor_dailyStatistic()} function separately for each timezone.
See \link{monitor_dailyStatistic} for more details.

The results are returned as a list of \emph{ws_monitor} objects with each element of the
list named with the associated timezone. Note that each \code{ws_monitor$data$datetime}
will be in local time. This is desirable as it ensures proper date formatting in tables and plots.

You should not attempt to reassemble a single \emph{ws_monitor} object from the elements in this list.
}
\examples{
\donttest{
# Fail gracefully if any resources are not available
try({

library(PWFSLSmoke)

airnow <- airnow_loadLatest()
nw <- monitor_subset(airnow, stateCodes = c('WA','OR','ID','MT'))
dailyList <- monitor_dailyStatisticList(nw)

monitor_leaflet(dailyList[["America/Los_Angeles"]])

monitor_leaflet(dailyList[["America/Boise"]])

monitor_leaflet(dailyList[["America/Denver"]])

}, silent = FALSE)
}
}
\references{
\link{monitor_dailyStatistic}
}
\keyword{ws_monitor}
